/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.line.XYNode;
import org.locationtech.jts.geom.Coordinate;

public class GraphViewer
extends JPanel {
    Graph graph;
    Collection nodes;
    double minX;
    double minY;
    int xScaling = 4;
    int yScaling = 4;
    int xOffset = 0;
    int yOffset = 0;
    boolean colorEdges = false;
    Color[] nodeColors = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.LIGHT_GRAY, Color.GRAY, Color.DARK_GRAY, Color.BLACK};
    Vector shortEdges;
    Vector longEdges;
    Vector otherEdges;

    public void setXScaling(int i) {
        this.xScaling = i;
    }

    public int getXScaling() {
        return this.xScaling;
    }

    public void setYScaling(int i) {
        this.yScaling = i;
    }

    public int getYScaling() {
        return this.yScaling;
    }

    public void setGraph(Graph gr) {
        this.graph = gr;
        this.nodes = this.graph.getNodes();
        Iterator it = this.nodes.iterator();
        this.minX = Double.MAX_VALUE;
        this.minY = Double.MAX_VALUE;
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof XYNode)) {
                throw new RuntimeException("I can't draw a node that doesn't have a coordinate.");
            }
            Coordinate coord = ((XYNode)next).getCoordinate();
            if (coord.x < this.minX) {
                this.minX = coord.x;
            }
            if (!(coord.y < this.minY)) continue;
            this.minY = coord.y;
        }
    }

    public void setColorEdges(boolean b) {
        this.colorEdges = b;
    }

    public void setShortEdges(Vector l) {
        this.shortEdges = l;
    }

    public void setLongEdges(Vector l) {
        this.longEdges = l;
    }

    public void setOtherEdges(Vector l) {
        this.otherEdges = l;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.xOffset = (int)Math.round((double)this.xScaling - this.minX * (double)this.xScaling);
        this.yOffset = (int)Math.round((double)this.yScaling - this.minY * (double)this.yScaling);
        for (Object next : this.nodes) {
            if (!(next instanceof XYNode)) {
                throw new RuntimeException("I can't draw a node that doesn't have a coordinate.");
            }
            Coordinate coord = ((XYNode)next).getCoordinate();
            g.fillOval((int)Math.round((double)this.xOffset + coord.x * (double)this.xScaling - 2.0), (int)Math.round((double)this.yOffset + coord.y * (double)this.yScaling - 2.0), 4, 4);
        }
        g.setColor(Color.RED);
        Collection<Edge> edges = this.graph.getEdges();
        for (Edge next : edges) {
            if (!(next.getNodeA() instanceof XYNode) || !(next.getNodeB() instanceof XYNode)) {
                throw new RuntimeException("I can't draw an edge without endpoint coordinates.");
            }
            Coordinate coordA = ((XYNode)next.getNodeA()).getCoordinate();
            Coordinate coordB = ((XYNode)next.getNodeB()).getCoordinate();
            if (this.colorEdges) {
                if (this.shortEdges.contains(next)) {
                    g.setColor(Color.RED);
                } else if (this.longEdges.contains(next)) {
                    g.setColor(Color.GREEN);
                } else if (this.otherEdges.contains(next)) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.YELLOW);
                }
            }
            g.drawLine((int)Math.round((double)this.xOffset + coordA.x * (double)this.xScaling), (int)Math.round((double)this.yOffset + coordA.y * (double)this.yScaling), (int)Math.round((double)this.xOffset + coordB.x * (double)this.xScaling), (int)Math.round((double)this.yOffset + coordB.y * (double)this.yScaling));
        }
    }
}

