/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.traverse.standard;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.geotools.graph.structure.DirectedGraphable;
import org.geotools.graph.structure.DirectedNode;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.GraphVisitor;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.basic.AbstractGraphIterator;

public class DirectedBreadthFirstTopologicalIterator
extends AbstractGraphIterator {
    private Queue<Graphable> m_queue;

    @Override
    public void init(Graph graph, GraphTraversal traversal) {
        this.m_queue = this.buildQueue(graph);
        graph.visitNodes(new GraphVisitor(){

            @Override
            public int visit(Graphable component) {
                DirectedNode node = (DirectedNode)component;
                node.setVisited(false);
                node.setCount(0);
                if (node.getInDegree() == 0) {
                    DirectedBreadthFirstTopologicalIterator.this.m_queue.add(node);
                }
                return 0;
            }
        });
    }

    @Override
    public Graphable next(GraphTraversal traversal) {
        return !this.m_queue.isEmpty() ? this.m_queue.remove() : null;
    }

    @Override
    public void cont(Graphable current, GraphTraversal traversal) {
        DirectedGraphable directed = (DirectedGraphable)current;
        Iterator<? extends Graphable> itr = directed.getOutRelated();
        while (itr.hasNext()) {
            DirectedNode related = (DirectedNode)itr.next();
            if (traversal.isVisited(related)) continue;
            related.setCount(related.getCount() + 1);
            if (related.getInDegree() != related.getCount()) continue;
            this.m_queue.add(related);
        }
    }

    @Override
    public void killBranch(Graphable current, GraphTraversal traversal) {
    }

    protected Queue<Graphable> buildQueue(Graph graph) {
        return new ArrayDeque<Graphable>(graph.getNodes().size());
    }
}

