/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.traverse.standard;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.geotools.graph.structure.DirectedGraphable;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.GraphVisitor;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.basic.SourceGraphIterator;

public class DijkstraIterator
extends SourceGraphIterator {
    private static Comparator<DijkstraNode> comparator = new Comparator<DijkstraNode>(){

        @Override
        public int compare(DijkstraNode n1, DijkstraNode n2) {
            return n1.cost < n2.cost ? -1 : (n1.cost > n2.cost ? 1 : 0);
        }
    };
    protected EdgeWeighter weighter;
    protected NodeWeighter nweighter;
    protected PriorityQueue<DijkstraNode> queue;
    protected HashMap<Graphable, DijkstraNode> nodemap;

    public DijkstraIterator(EdgeWeighter weighter) {
        this(weighter, null);
    }

    public DijkstraIterator(EdgeWeighter weighter, NodeWeighter nweighter) {
        this.weighter = weighter;
        this.nweighter = nweighter;
    }

    @Override
    public void init(Graph graph, GraphTraversal traversal) {
        this.nodemap = new HashMap();
        this.queue = new PriorityQueue<DijkstraNode>(graph.getNodes().size(), comparator);
        graph.visitNodes(new GraphVisitor(){

            @Override
            public int visit(Graphable component) {
                DijkstraNode dn = new DijkstraNode((Node)component, Double.MAX_VALUE);
                DijkstraIterator.this.nodemap.put(component, dn);
                if (component == DijkstraIterator.this.getSource()) {
                    dn.cost = 0.0;
                }
                DijkstraIterator.this.queue.add(dn);
                return 0;
            }
        });
    }

    @Override
    public Graphable next(GraphTraversal traversal) {
        if (this.queue.isEmpty()) {
            return null;
        }
        DijkstraNode next = (DijkstraNode)this.queue.remove();
        if (next.cost == Double.MAX_VALUE) {
            return null;
        }
        return next.node;
    }

    @Override
    public void cont(Graphable current, GraphTraversal traversal) {
        DijkstraNode currdn = this.nodemap.get(current);
        Iterator<? extends Graphable> itr = this.getRelated(current);
        while (itr.hasNext()) {
            Node related = (Node)itr.next();
            if (traversal.isVisited(related)) continue;
            DijkstraNode reldn = this.nodemap.get(related);
            double cost = this.weighter.getWeight(currdn.node.getEdge(related)) + currdn.cost;
            if (!(cost < reldn.cost)) continue;
            this.queue.remove(reldn);
            reldn.cost = cost;
            reldn.parent = currdn;
            this.queue.add(reldn);
        }
    }

    @Override
    public void killBranch(Graphable current, GraphTraversal traversal) {
    }

    public double getCost(Graphable component) {
        return this.nodemap.get((Object)component).cost;
    }

    public Graphable getParent(Graphable component) {
        if (component.equals(this.getSource())) {
            return null;
        }
        DijkstraNode dn = this.nodemap.get(component);
        if (dn == null || dn.parent == null) {
            return null;
        }
        return dn.parent.node;
    }

    protected PriorityQueue getQueue() {
        return this.queue;
    }

    protected Iterator<? extends Graphable> getRelated(Graphable current) {
        if (current instanceof DirectedGraphable) {
            return ((DirectedGraphable)current).getOutRelated();
        }
        return current.getRelated();
    }

    protected static class DijkstraNode {
        public Node node;
        public double cost;
        public DijkstraNode parent;

        public DijkstraNode(Node node, double cost) {
            this.node = node;
            this.cost = cost;
        }
    }

    public static interface NodeWeighter {
        public double getWeight(Node var1, Edge var2, Edge var3);
    }

    public static interface EdgeWeighter {
        public double getWeight(Edge var1);
    }
}

