/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.traverse.standard;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.geotools.graph.structure.DirectedGraphable;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.basic.SourceGraphIterator;

public class AStarIterator
extends SourceGraphIterator {
    private AStarFunctions m_afuncs;
    private PriorityQueue<AStarNode> m_pqueue;
    private HashMap<Node, AStarNode> m_nodemap;
    private static Comparator<AStarNode> comparator = new Comparator<AStarNode>(){

        @Override
        public int compare(AStarNode o1, AStarNode o2) {
            AStarNode n1 = o1;
            AStarNode n2 = o2;
            return n1.getF() < n2.getF() ? -1 : (n1.getF() > n2.getF() ? 1 : 0);
        }
    };

    public AStarIterator(Node source, AStarFunctions afuncs) {
        this.m_afuncs = afuncs;
        AStarNode asn = new AStarNode(source, afuncs.h(source));
        asn.setG(0.0);
        this.setSource(source);
        this.m_nodemap = new HashMap();
        this.m_nodemap.put(source, asn);
        this.m_pqueue = new PriorityQueue<AStarNode>(100, comparator);
        this.m_pqueue.add(asn);
    }

    @Override
    public void init(Graph graph, GraphTraversal traversal) {
    }

    @Override
    public Graphable next(GraphTraversal traversal) {
        if (this.m_pqueue.isEmpty()) {
            return null;
        }
        AStarNode next = (AStarNode)this.m_pqueue.remove();
        return next.getNode();
    }

    @Override
    public void cont(Graphable current, GraphTraversal traversal) {
        Node currdn = (Node)current;
        AStarNode currAsn = this.m_nodemap.get(currdn);
        if (currAsn == null) {
            throw new IllegalArgumentException("AStarIterator: The node is not in the open list");
        }
        currAsn.close();
        Iterator<?> itr = this.getRelated(current);
        while (itr.hasNext()) {
            AStarNode nextAsn;
            Node next = (Node)itr.next();
            if (this.m_nodemap.containsKey(next)) {
                nextAsn = this.m_nodemap.get(next);
                if (nextAsn.isClosed() || !(currAsn.getG() + this.m_afuncs.cost(currAsn, nextAsn) < nextAsn.getG())) continue;
                this.m_pqueue.remove(nextAsn);
                nextAsn.setG(currAsn.getG() + this.m_afuncs.cost(currAsn, nextAsn));
                nextAsn.setParent(currAsn);
                this.m_pqueue.add(nextAsn);
                continue;
            }
            nextAsn = new AStarNode(next, this.m_afuncs.h(next));
            nextAsn.setG(currAsn.getG() + this.m_afuncs.cost(currAsn, nextAsn));
            nextAsn.setParent(currAsn);
            this.m_pqueue.add(nextAsn);
            this.m_nodemap.put(next, nextAsn);
        }
    }

    @Override
    public void killBranch(Graphable current, GraphTraversal traversal) {
    }

    public Node getParent(Node n) {
        AStarNode asn = this.m_nodemap.get(n);
        return asn == null ? null : (asn.getParent() == null ? null : asn.getParent().getNode());
    }

    protected Iterator<?> getRelated(Graphable current) {
        if (current instanceof DirectedGraphable) {
            return ((DirectedGraphable)current).getOutRelated();
        }
        return current.getRelated();
    }

    public static abstract class AStarFunctions {
        private Node dest;

        public AStarFunctions(Node destination) {
            this.dest = destination;
        }

        public void setDestination(Node destination) {
            this.dest = destination;
        }

        public abstract double cost(AStarNode var1, AStarNode var2);

        public abstract double h(Node var1);

        public Node getDest() {
            return this.dest;
        }
    }

    public static class AStarNode {
        private Node node;
        private AStarNode parent;
        private double g;
        private double h;
        private boolean closed;

        public AStarNode(Node n, double h_val) {
            this.node = n;
            this.parent = null;
            this.g = Double.POSITIVE_INFINITY;
            this.h = h_val;
            this.closed = false;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void close() {
            this.closed = true;
        }

        public double getG() {
            return this.g;
        }

        public double getH() {
            return this.h;
        }

        public double getF() {
            return this.g + this.h;
        }

        public AStarNode getParent() {
            return this.parent;
        }

        public Node getNode() {
            return this.node;
        }

        public void setG(double value) {
            this.g = value;
        }

        public void setH(double value) {
            this.h = value;
        }

        public void setNode(Node n) {
            this.node = n;
        }

        public void setParent(AStarNode an) {
            this.parent = an;
        }
    }
}

