/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.basic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.geotools.graph.structure.DirectedEdge;
import org.geotools.graph.structure.DirectedNode;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraphable;

public class BasicDirectedEdge
extends BasicGraphable
implements DirectedEdge {
    private DirectedNode m_in;
    private DirectedNode m_out;

    public BasicDirectedEdge(DirectedNode in, DirectedNode out) {
        this.m_in = in;
        this.m_out = out;
    }

    @Override
    public DirectedNode getInNode() {
        return this.m_in;
    }

    @Override
    public DirectedNode getOutNode() {
        return this.m_out;
    }

    @Override
    public Node getNodeA() {
        return this.m_in;
    }

    @Override
    public Node getNodeB() {
        return this.m_out;
    }

    @Override
    public Node getOtherNode(Node node) {
        return this.m_in.equals(node) ? this.m_out : (this.m_out.equals(node) ? this.m_in : null);
    }

    @Override
    public void reverse() {
        this.m_in.removeOut(this);
        this.m_out.removeIn(this);
        DirectedNode tmp = this.m_in;
        this.m_in = this.m_out;
        this.m_out = tmp;
        this.m_in.addOut(this);
        this.m_out.addIn(this);
    }

    public Iterator<Edge> getRelated() {
        HashSet<Edge> related = new HashSet<Edge>();
        related.addAll(this.m_in.getEdges());
        related.addAll(this.m_out.getEdges());
        related.remove(this);
        return related.iterator();
    }

    public Iterator<DirectedEdge> getInRelated() {
        ArrayList<DirectedEdge> in = new ArrayList<DirectedEdge>();
        for (DirectedEdge directedEdge : this.m_in.getInEdges()) {
            if (directedEdge.equals(this)) continue;
            in.add(directedEdge);
        }
        return in.iterator();
    }

    public Iterator<DirectedEdge> getOutRelated() {
        ArrayList<DirectedEdge> out = new ArrayList<DirectedEdge>();
        for (DirectedEdge directedEdge : this.m_out.getOutEdges()) {
            if (directedEdge.equals(this)) continue;
            out.add(directedEdge);
        }
        return out.iterator();
    }

    @Override
    public int compareNodes(Edge other) {
        if (other instanceof DirectedEdge) {
            DirectedEdge de = (DirectedEdge)other;
            if (de.getInNode().equals(this.m_in) && de.getOutNode().equals(this.m_out)) {
                return 0;
            }
            if (de.getInNode().equals(this.m_out) && de.getOutNode().equals(this.m_in)) {
                return -1;
            }
        }
        return 1;
    }
}

