/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.build.line;

import java.util.HashMap;
import java.util.Map;
import org.geotools.graph.build.line.OptDirectedLineGraphBuilder;
import org.geotools.graph.build.line.OptLineGraphGenerator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.line.OptDirectedXYNode;
import org.geotools.graph.structure.opt.OptDirectedNode;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;

public class OptDirectedLineGraphGenerator
extends OptLineGraphGenerator {
    HashMap m_in2count = new HashMap();
    HashMap m_out2count = new HashMap();

    public OptDirectedLineGraphGenerator() {
        this.setGraphBuilder(new OptDirectedLineGraphBuilder());
    }

    @Override
    public Graphable add(Object obj) {
        LineSegment line = (LineSegment)obj;
        Integer count = (Integer)this.m_in2count.get(line.p0);
        if (count == null) {
            this.m_in2count.put(line.p0, 1);
        } else {
            this.m_in2count.put(line.p0, count + 1);
        }
        count = (Integer)this.m_out2count.get(line.p1);
        if (count == null) {
            this.m_out2count.put(line.p1, 1);
        } else {
            this.m_out2count.put(line.p1, count + 1);
        }
        this.getLines().add(line);
        return null;
    }

    public Map getInNodeMap() {
        return this.m_in2count;
    }

    public Map getOutNodeMap() {
        return this.m_out2count;
    }

    @Override
    protected void generateNodes() {
        OptDirectedXYNode node;
        Integer count;
        Coordinate coord;
        for (Map.Entry entry : this.m_in2count.entrySet()) {
            coord = (Coordinate)entry.getKey();
            count = (Integer)entry.getValue();
            node = (OptDirectedXYNode)this.getGraphBuilder().buildNode();
            node.setCoordinate(coord);
            node.setOutDegree(count);
            count = (Integer)this.m_out2count.get(coord);
            if (count != null) {
                node.setInDegree(count);
            } else {
                node.setInDegree(0);
            }
            this.getGraphBuilder().addNode(node);
            entry.setValue(node);
        }
        for (Map.Entry entry : this.m_out2count.entrySet()) {
            coord = (Coordinate)entry.getKey();
            count = (Integer)entry.getValue();
            node = (OptDirectedXYNode)this.m_in2count.get(coord);
            if (node == null) {
                node = (OptDirectedXYNode)this.getGraphBuilder().buildNode();
                node.setCoordinate(coord);
                node.setOutDegree(0);
                node.setInDegree(count);
                this.getGraphBuilder().addNode(node);
            }
            entry.setValue(node);
        }
    }

    @Override
    protected Edge generateEdge(LineSegment line) {
        OptDirectedNode n1 = (OptDirectedNode)this.m_in2count.get(line.p0);
        OptDirectedNode n2 = (OptDirectedNode)this.m_out2count.get(line.p1);
        Edge edge = this.getGraphBuilder().buildEdge(n1, n2);
        this.getGraphBuilder().addEdge(edge);
        return edge;
    }

    @Override
    public Node getNode(Coordinate c) {
        Node n = (Node)this.m_in2count.get(c);
        if (n != null) {
            return n;
        }
        return (Node)this.m_out2count.get(c);
    }

    @Override
    public Edge getEdge(Coordinate c1, Coordinate c2) {
        return null;
    }
}

