/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraph;
import org.geotools.graph.util.delaunay.AutoClustData;
import org.geotools.graph.util.delaunay.AutoClustUtils;
import org.geotools.graph.util.delaunay.DelaunayEdge;
import org.geotools.graph.util.delaunay.DelaunayNode;
import org.geotools.graph.util.delaunay.GraphViewer;
import org.geotools.util.logging.Logging;

public class AutoClust {
    private static final Logger LOGGER = Logging.getLogger(AutoClust.class);

    public static Graph runAutoClust(Graph d) {
        Node other;
        HashMap<DelaunayNode, AutoClustData> map = new HashMap<DelaunayNode, AutoClustData>();
        Collection<Node> nodes = d.getNodes();
        Collection<Edge> edges = d.getEdges();
        AutoClust.showGraph(nodes, edges, 0);
        Iterator<Node> nodeIt = nodes.iterator();
        double[] localDevs = new double[nodes.size()];
        int index = 0;
        while (nodeIt.hasNext()) {
            double stDev;
            DelaunayNode next = (DelaunayNode)nodeIt.next();
            AutoClustData acd = new AutoClustData();
            Object localEdges = AutoClustUtils.findAdjacentEdges(next, edges);
            double totalLength = 0.0;
            Iterator edgeIt = localEdges.iterator();
            while (edgeIt.hasNext()) {
                DelaunayEdge nextEdge = (DelaunayEdge)edgeIt.next();
                totalLength += nextEdge.getEuclideanDistance();
            }
            double meanLength = totalLength / (double)localEdges.size();
            double d2 = 0.0;
            Iterator anotherEdgeIt = localEdges.iterator();
            while (anotherEdgeIt.hasNext()) {
                DelaunayEdge nextEdge = (DelaunayEdge)anotherEdgeIt.next();
                d2 += Math.pow(nextEdge.getEuclideanDistance() - meanLength, 2.0);
            }
            double variance = d2 / (double)localEdges.size();
            localDevs[index] = stDev = Math.sqrt(variance);
            ++index;
            acd.setLocalMean(meanLength);
            acd.setLocalStDev(stDev);
            map.put(next, acd);
        }
        double total = 0.0;
        for (double localDev : localDevs) {
            total += localDev;
        }
        double meanStDev = total / (double)localDevs.length;
        ArrayList<Edge> allShortEdges = new ArrayList<Edge>();
        ArrayList<Edge> allLongEdges = new ArrayList<Edge>();
        ArrayList<Edge> allOtherEdges = new ArrayList<Edge>();
        for (DelaunayNode delaunayNode : nodes) {
            List<Edge> localEdges = AutoClustUtils.findAdjacentEdges(delaunayNode, edges);
            AutoClustData acd = (AutoClustData)map.get(delaunayNode);
            Iterator<Edge> edgeIt = localEdges.iterator();
            ArrayList<Edge> arrayList = new ArrayList<Edge>();
            ArrayList<Edge> longEdges = new ArrayList<Edge>();
            ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
            LOGGER.fine("local mean is " + acd.getLocalMean());
            LOGGER.fine("mean st dev is " + meanStDev);
            while (edgeIt.hasNext()) {
                DelaunayEdge delaunayEdge = (DelaunayEdge)edgeIt.next();
                double length = delaunayEdge.getEuclideanDistance();
                if (length < acd.getLocalMean() - meanStDev) {
                    arrayList.add(delaunayEdge);
                    LOGGER.finer(String.valueOf(delaunayEdge) + ": length " + delaunayEdge.getEuclideanDistance() + " is short");
                    continue;
                }
                if (length > acd.getLocalMean() + meanStDev) {
                    longEdges.add(delaunayEdge);
                    LOGGER.finer(String.valueOf(delaunayEdge) + ": length " + delaunayEdge.getEuclideanDistance() + " is long");
                    continue;
                }
                arrayList2.add(delaunayEdge);
                LOGGER.finer(String.valueOf(delaunayEdge) + ": length " + delaunayEdge.getEuclideanDistance() + " is medium");
            }
            acd.setShortEdges(arrayList);
            acd.setLongEdges(longEdges);
            acd.setOtherEdges(arrayList2);
            allLongEdges.addAll(longEdges);
            allShortEdges.addAll(arrayList);
            allOtherEdges.addAll(arrayList2);
        }
        BasicGraph basicGraph = new BasicGraph(nodes, edges);
        JFrame frame = new JFrame();
        GraphViewer viewer = new GraphViewer();
        viewer.setLongEdges(allLongEdges);
        viewer.setShortEdges(allShortEdges);
        viewer.setOtherEdges(allOtherEdges);
        viewer.setColorEdges(true);
        viewer.setGraph(basicGraph);
        frame.getContentPane().add(viewer);
        frame.setDefaultCloseOperation(3);
        frame.setSize(new Dimension(800, 800));
        frame.setTitle("Assigned edge categories");
        frame.setVisible(true);
        for (DelaunayNode delaunayNode : nodes) {
            AutoClustData acd = (AutoClustData)map.get(delaunayNode);
            List<Edge> list = acd.getShortEdges();
            List<Edge> list2 = acd.getLongEdges();
            edges.removeAll(list);
            LOGGER.finer("removed " + String.valueOf(list));
            edges.removeAll(list2);
            LOGGER.finer("removed " + String.valueOf(list2));
        }
        LOGGER.fine("End of phase one and ");
        LOGGER.fine("Nodes are " + String.valueOf(nodes));
        LOGGER.fine("Edges are " + String.valueOf(edges));
        AutoClust.showGraph(nodes, edges, 1);
        List<Graph> list = AutoClustUtils.findConnectedComponents(nodes, edges);
        for (DelaunayNode delaunayNode : nodes) {
            Graph gr;
            AutoClustData autoClustData = (AutoClustData)map.get(delaunayNode);
            List<Edge> shortEdges = autoClustData.getShortEdges();
            if (!shortEdges.isEmpty()) {
                ArrayList<Graph> shortlyConnectedComponents = new ArrayList<Graph>();
                for (Edge nextEdge : shortEdges) {
                    other = nextEdge.getOtherNode(delaunayNode);
                    Graph g = AutoClust.getMyComponent(other, list);
                    if (shortlyConnectedComponents.contains(g)) continue;
                    shortlyConnectedComponents.add(g);
                }
                Graph cv = null;
                if (shortlyConnectedComponents.size() > 1) {
                    Iterator sccIt = shortlyConnectedComponents.iterator();
                    int maxSize = 0;
                    while (sccIt.hasNext()) {
                        Graph nextGraph = (Graph)sccIt.next();
                        int size = nextGraph.getNodes().size();
                        if (size <= maxSize) continue;
                        maxSize = size;
                        cv = nextGraph;
                    }
                } else {
                    cv = (Graph)shortlyConnectedComponents.get(0);
                }
                for (Edge nextEdge : shortEdges) {
                    Node other2 = nextEdge.getOtherNode(delaunayNode);
                    if (!cv.equals(AutoClust.getMyComponent(other2, shortlyConnectedComponents))) continue;
                    edges.add(nextEdge);
                }
            }
            if ((gr = AutoClust.getMyComponent(delaunayNode, list)).getNodes().size() != 1) continue;
            ArrayList<Graph> shortlyConnectedComponents = new ArrayList<Graph>();
            for (Edge nextEdge : shortEdges) {
                Node other3 = nextEdge.getOtherNode(delaunayNode);
                Graph g = AutoClust.getMyComponent(other3, list);
                if (shortlyConnectedComponents.contains(g)) continue;
                shortlyConnectedComponents.add(g);
            }
            if (shortlyConnectedComponents.size() != 1) continue;
            edges.addAll(shortEdges);
        }
        LOGGER.fine("End of phase two and ");
        LOGGER.fine("Nodes are " + String.valueOf(nodes));
        LOGGER.fine("Edges are " + String.valueOf(edges));
        AutoClust.showGraph(nodes, edges, 2);
        List<Graph> list3 = AutoClustUtils.findConnectedComponents(nodes, edges);
        for (DelaunayNode delaunayNode : nodes) {
            ArrayList<Edge> edgesWithinTwo = new ArrayList<Edge>();
            List<Edge> adjacentEdges = AutoClustUtils.findAdjacentEdges(delaunayNode, edges);
            edgesWithinTwo.addAll(adjacentEdges);
            for (Edge nextEdge : adjacentEdges) {
                other = nextEdge.getOtherNode(delaunayNode);
                List<Edge> adjacentToOther = AutoClustUtils.findAdjacentEdges(other, edges);
                for (Edge nextEdge2 : adjacentToOther) {
                    if (edgesWithinTwo.contains(nextEdge2)) continue;
                    edgesWithinTwo.add(nextEdge2);
                }
            }
            double totalLength = 0.0;
            Iterator ewtIt = edgesWithinTwo.iterator();
            while (ewtIt.hasNext()) {
                totalLength += ((DelaunayEdge)ewtIt.next()).getEuclideanDistance();
            }
            double local2Mean = totalLength / (double)edgesWithinTwo.size();
            for (DelaunayEdge delaunayEdge : edgesWithinTwo) {
                if (!(delaunayEdge.getEuclideanDistance() > local2Mean + meanStDev)) continue;
                edges.remove(delaunayEdge);
            }
        }
        LOGGER.fine("End of phase three and ");
        LOGGER.fine("Nodes are " + String.valueOf(nodes));
        LOGGER.fine("Edges are " + String.valueOf(edges));
        AutoClust.showGraph(nodes, edges, 3);
        List<Graph> list4 = AutoClustUtils.findConnectedComponents(nodes, edges);
        return new BasicGraph(nodes, edges);
    }

    private static Graph getMyComponent(Node node, List components) {
        Iterator it = components.iterator();
        Graph ret = null;
        boolean found = false;
        while (it.hasNext() && !found) {
            Graph next = (Graph)it.next();
            if (!next.getNodes().contains(node)) continue;
            found = true;
            ret = next;
        }
        if (ret == null) {
            throw new RuntimeException("Couldn't find the graph component containing node: " + String.valueOf(node));
        }
        return ret;
    }

    private static void showGraph(Collection<Node> nodes, Collection<Edge> edges, int phase) {
        BasicGraph g = new BasicGraph(nodes, edges);
        JFrame frame = new JFrame();
        GraphViewer viewer = new GraphViewer();
        viewer.setGraph(g);
        frame.getContentPane().add(viewer);
        frame.setDefaultCloseOperation(3);
        frame.setSize(new Dimension(800, 800));
        frame.setTitle("Phase " + phase);
        frame.setVisible(true);
    }
}

