/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util;

import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import javax.swing.filechooser.FileFilter;

public class SimpleFileFilter
extends FileFilter
implements Serializable {
    private String m_ext = null;
    private String m_desc = null;

    public SimpleFileFilter() {
    }

    public SimpleFileFilter(String ext, String desc) {
        this.m_ext = ext;
        this.m_desc = desc;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String path = f.getAbsolutePath();
        if (path.length() < this.m_ext.length() + 1) {
            return false;
        }
        return path.substring(path.length() - 4).equals("." + this.m_ext);
    }

    public String getExtension() {
        return this.m_ext;
    }

    @Override
    public String getDescription() {
        return this.m_desc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SimpleFileFilter) {
            SimpleFileFilter other = (SimpleFileFilter)o;
            return this.m_ext.equals(other.m_ext);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_ext);
    }
}

