/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.traverse.standard;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.basic.SourceGraphIterator;

public class BreadthFirstIterator
extends SourceGraphIterator {
    private Queue<Graphable> m_active;

    @Override
    public void setSource(Graphable source) {
        super.setSource(source);
        if (this.m_active == null) {
            this.m_active = this.buildQueue(this.getGraph());
        } else if (this.m_active.isEmpty()) {
            this.m_active.clear();
        }
        this.m_active.add(this.getSource());
    }

    @Override
    public void init(Graph graph, GraphTraversal traversal) {
    }

    @Override
    public Graphable next(GraphTraversal traversal) {
        while (!this.m_active.isEmpty()) {
            Graphable next = this.m_active.remove();
            if (traversal.isVisited(next)) continue;
            return next;
        }
        return null;
    }

    @Override
    public void cont(Graphable current, GraphTraversal traversal) {
        Iterator<? extends Graphable> itr = current.getRelated();
        while (itr.hasNext()) {
            Node related = (Node)itr.next();
            if (traversal.isVisited(related)) continue;
            this.m_active.add(related);
        }
    }

    @Override
    public void killBranch(Graphable current, GraphTraversal traversal) {
    }

    protected Queue<Graphable> buildQueue(Graph graph) {
        return new ArrayDeque<Graphable>(graph.getNodes().size());
    }

    protected Queue<Graphable> getQueue() {
        return this.m_active;
    }
}

