/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Objects;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.line.XYNode;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class Triangle {
    Edge edge1;
    Edge edge2;
    Edge edge3;
    Node node1;
    Node node2;
    Node node3;
    GeometryFactory fact = new GeometryFactory();
    public static final int OUTSIDE = 0;
    public static final int INSIDE = 1;
    public static final int ON_EDGE = 2;
    private static final double TOLERANCE = 1.0E-4;

    public Triangle(Edge e1, Edge e2, Edge e3) {
        Node n1a = e1.getNodeA();
        Node n1b = e1.getNodeB();
        Node n2a = e2.getNodeA();
        Node n2b = e2.getNodeB();
        Node n3a = e3.getNodeA();
        Node n3b = e3.getNodeB();
        if (n1a.equals(n2a)) {
            Node temp1 = n1a;
            Node temp2 = n1b;
            Node temp3 = n2b;
            if (n3a.equals(temp2)) {
                if (n3b.equals(temp3)) {
                    this.assign(e1, e2, e3, temp1, temp2, temp3);
                } else {
                    this.whinge(e1, e2, e3);
                }
            } else if (n3a.equals(temp3)) {
                if (n3b.equals(temp2)) {
                    this.assign(e1, e2, e3, temp1, temp2, temp3);
                } else {
                    this.whinge(e1, e2, e3);
                }
            } else {
                this.whinge(e1, e2, e3);
            }
        } else if (n1a.equals(n2b)) {
            Node temp1 = n1a;
            Node temp2 = n1b;
            Node temp3 = n2a;
            if (n3a.equals(temp2)) {
                if (n3b.equals(temp3)) {
                    this.assign(e1, e2, e3, temp1, temp2, temp3);
                } else {
                    this.whinge(e1, e2, e3);
                }
            } else if (n3a.equals(temp3)) {
                if (n3b.equals(temp2)) {
                    this.assign(e1, e2, e3, temp1, temp2, temp3);
                } else {
                    this.whinge(e1, e2, e3);
                }
            } else {
                this.whinge(e1, e2, e3);
            }
        } else if (n1b.equals(n2a)) {
            Node temp1 = n1a;
            Node temp2 = n1b;
            Node temp3 = n2b;
            if (n3a.equals(temp1)) {
                if (n3b.equals(temp3)) {
                    this.assign(e1, e2, e3, temp1, temp2, temp3);
                } else {
                    this.whinge(e1, e2, e3);
                }
            } else if (n3a.equals(temp3)) {
                if (n3b.equals(temp1)) {
                    this.assign(e1, e2, e3, temp1, temp2, temp3);
                } else {
                    this.whinge(e1, e2, e3);
                }
            } else {
                this.whinge(e1, e2, e3);
            }
        } else if (n1b.equals(n2b)) {
            Node temp1 = n1a;
            Node temp2 = n1b;
            Node temp3 = n2a;
            if (n3a.equals(temp1)) {
                if (n3b.equals(temp3)) {
                    this.assign(e1, e2, e3, temp1, temp2, temp3);
                } else {
                    this.whinge(e1, e2, e3);
                }
            } else if (n3a.equals(temp3)) {
                if (n3b.equals(temp1)) {
                    this.assign(e1, e2, e3, temp1, temp2, temp3);
                } else {
                    this.whinge(e1, e2, e3);
                }
            } else {
                this.whinge(e1, e2, e3);
            }
        } else {
            this.whinge(e1, e2, e3);
        }
    }

    private void assign(Edge e1, Edge e2, Edge e3, Node n1, Node n2, Node n3) {
        this.edge1 = e1;
        this.edge2 = e2;
        this.edge3 = e3;
        this.node1 = n1;
        this.node2 = n2;
        this.node3 = n3;
    }

    private void whinge(Edge e1, Edge e2, Edge e3) {
        throw new RuntimeException("You didn't give me a proper triangle.  " + String.valueOf(e1) + ", " + String.valueOf(e2) + ", " + String.valueOf(e3));
    }

    public int relate(XYNode n) {
        if (!(this.node1 instanceof XYNode && this.node2 instanceof XYNode && this.node3 instanceof XYNode)) {
            throw new RuntimeException("I can't perform a relate function on a non-spatial triangle");
        }
        LinearRing lr = this.fact.createLinearRing(new Coordinate[]{((XYNode)this.node1).getCoordinate(), ((XYNode)this.node2).getCoordinate(), ((XYNode)this.node3).getCoordinate(), ((XYNode)this.node1).getCoordinate()});
        Polygon poly = this.fact.createPolygon(lr, null);
        Point nPoint = this.fact.createPoint(n.getCoordinate());
        Line2D.Double line12 = new Line2D.Double(((XYNode)this.node1).getCoordinate().x, ((XYNode)this.node1).getCoordinate().y, ((XYNode)this.node2).getCoordinate().x, ((XYNode)this.node2).getCoordinate().y);
        Line2D.Double line13 = new Line2D.Double(((XYNode)this.node1).getCoordinate().x, ((XYNode)this.node1).getCoordinate().y, ((XYNode)this.node3).getCoordinate().x, ((XYNode)this.node3).getCoordinate().y);
        Line2D.Double line23 = new Line2D.Double(((XYNode)this.node2).getCoordinate().x, ((XYNode)this.node2).getCoordinate().y, ((XYNode)this.node3).getCoordinate().x, ((XYNode)this.node3).getCoordinate().y);
        Point2D.Double point2D = new Point2D.Double(n.getCoordinate().x, n.getCoordinate().y);
        int ret = line12.ptSegDist(point2D) <= 1.0E-4 || line13.ptSegDist(point2D) <= 1.0E-4 || line23.ptSegDist(point2D) <= 1.0E-4 ? 2 : (poly.contains((Geometry)nPoint) ? 1 : 0);
        return ret;
    }

    public Edge getBoundaryEdge(XYNode n) {
        if (this.relate(n) != 2) {
            throw new RuntimeException("Can't get the boundary edge for a point that isn't on an edge.");
        }
        Point2D.Double point = new Point2D.Double(n.getCoordinate().x, n.getCoordinate().y);
        Line2D.Double line1 = new Line2D.Double(((XYNode)this.edge1.getNodeA()).getCoordinate().x, ((XYNode)this.edge1.getNodeA()).getCoordinate().y, ((XYNode)this.edge1.getNodeB()).getCoordinate().x, ((XYNode)this.edge1.getNodeB()).getCoordinate().y);
        Line2D.Double line2 = new Line2D.Double(((XYNode)this.edge2.getNodeA()).getCoordinate().x, ((XYNode)this.edge2.getNodeA()).getCoordinate().y, ((XYNode)this.edge2.getNodeB()).getCoordinate().x, ((XYNode)this.edge2.getNodeB()).getCoordinate().y);
        Line2D.Double line3 = new Line2D.Double(((XYNode)this.edge3.getNodeA()).getCoordinate().x, ((XYNode)this.edge3.getNodeA()).getCoordinate().y, ((XYNode)this.edge3.getNodeB()).getCoordinate().x, ((XYNode)this.edge3.getNodeB()).getCoordinate().y);
        Edge ret = null;
        if (line1.ptSegDist(point) <= 1.0E-4) {
            ret = this.edge1;
        } else if (line2.ptSegDist(point) <= 1.0E-4) {
            ret = this.edge2;
        } else if (line3.ptSegDist(point) <= 1.0E-4) {
            ret = this.edge3;
        } else {
            throw new RuntimeException("So...  node " + String.valueOf(n) + " is on an edge of " + this.toString() + " but isn't on any of its edges: " + String.valueOf(this.edge1) + ", " + String.valueOf(this.edge2) + ", or " + String.valueOf(this.edge3));
        }
        return ret;
    }

    public Node getThirdNode(Edge e) {
        if (e.getNodeA().equals(this.node1)) {
            if (e.getNodeB().equals(this.node2)) {
                return this.node3;
            }
            if (e.getNodeB().equals(this.node3)) {
                return this.node2;
            }
            throw new RuntimeException("Edge e must be in this triangle for Triangle.getThirdNode to work!");
        }
        if (e.getNodeA().equals(this.node2)) {
            if (e.getNodeB().equals(this.node1)) {
                return this.node3;
            }
            if (e.getNodeB().equals(this.node3)) {
                return this.node1;
            }
            throw new RuntimeException("Edge e must be in this triangle for Triangle.getThirdNode to work!");
        }
        if (e.getNodeA().equals(this.node3)) {
            if (e.getNodeB().equals(this.node2)) {
                return this.node1;
            }
            if (e.getNodeB().equals(this.node1)) {
                return this.node2;
            }
            throw new RuntimeException("Edge e must be in this triangle for Triangle.getThirdNode to work!");
        }
        throw new RuntimeException("Edge " + String.valueOf(e) + " must be in this triangle " + this.toString() + " for Triangle.getThirdNode to work!");
    }

    public Edge getOppositeEdge(Node n) {
        if (this.edge1.getNodeA().equals(n) || this.edge1.getNodeB().equals(n)) {
            if (this.edge2.getNodeA().equals(n) || this.edge2.getNodeB().equals(n)) {
                return this.edge3;
            }
            if (this.edge3.getNodeA().equals(n) || this.edge3.getNodeB().equals(n)) {
                return this.edge2;
            }
            throw new RuntimeException("Node n must be in this triangle for Triangle.getOppositeEdge to work!");
        }
        if (this.edge2.getNodeA().equals(n) || this.edge2.getNodeB().equals(n)) {
            if (this.edge3.getNodeA().equals(n) || this.edge3.getNodeB().equals(n)) {
                return this.edge1;
            }
            throw new RuntimeException("Node n must be in this triangle for Triangle.getOppositeEdge to work!");
        }
        throw new RuntimeException("Node n must be in this triangle for Triangle.getOppositeEdge to work!");
    }

    public Edge getSharedEdge(Triangle t) {
        Edge[] tEdges = t.getEdges();
        Edge shared = null;
        for (int i = 0; i < 3; ++i) {
            if (tEdges[i].equals(this.edge1)) {
                shared = this.edge1;
                continue;
            }
            if (tEdges[i].equals(this.edge2)) {
                shared = this.edge2;
                continue;
            }
            if (!tEdges[i].equals(this.edge3)) continue;
            shared = this.edge3;
        }
        return shared;
    }

    public Edge[] getEdges() {
        return new Edge[]{this.edge1, this.edge2, this.edge3};
    }

    public Node[] getNodes() {
        return new Node[]{this.node1, this.node2, this.node3};
    }

    public double getArea() {
        if (this.node1 instanceof XYNode || this.node2 instanceof XYNode || this.node3 instanceof XYNode) {
            double x1 = ((XYNode)this.node1).getCoordinate().x;
            double y1 = ((XYNode)this.node1).getCoordinate().y;
            double x2 = ((XYNode)this.node2).getCoordinate().x;
            double y2 = ((XYNode)this.node2).getCoordinate().y;
            double x3 = ((XYNode)this.node3).getCoordinate().x;
            double y3 = ((XYNode)this.node3).getCoordinate().y;
            double length1_2 = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            double length1_3 = Math.sqrt((x1 - x3) * (x1 - x3) + (y1 - y3) * (y1 - y3));
            double length2_3 = Math.sqrt((x2 - x3) * (x2 - x3) + (y2 - y3) * (y2 - y3));
            double s = (length1_2 + length1_3 + length2_3) / 2.0;
            return Math.sqrt(s * (s - length1_2) * (s - length1_3) * (s - length2_3));
        }
        throw new RuntimeException("I can't calculate the area if the triangle doesn't have XY coordinates.");
    }

    public boolean containsEdge(Edge e) {
        return this.edge1.equals(e) || this.edge2.equals(e) || this.edge3.equals(e);
    }

    public boolean equals(Object o) {
        boolean ret = o instanceof Triangle ? this.containsEdge(((Triangle)o).getEdges()[0]) && this.containsEdge(((Triangle)o).getEdges()[1]) && this.containsEdge(((Triangle)o).getEdges()[2]) : false;
        return ret;
    }

    public int hashCode() {
        return Objects.hash(this.edge1, this.edge2, this.edge3, this.node1, this.node2, this.node3, this.fact);
    }

    public String toString() {
        return "{" + this.node1.toString() + ", " + this.node2.toString() + ", " + this.node3.toString() + "}";
    }
}

