/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraph;
import org.geotools.graph.util.delaunay.DelaunayEdge;
import org.geotools.graph.util.delaunay.DelaunayNode;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;

public class PoissonClusterer {
    private static double threshold = 1.0E-10;

    public static Graph findClusters(Graph incoming, Expression base, Expression target, double meanRate, int distance) {
        Collection<Node> nodes = incoming.getNodes();
        Iterator<Node> nodeIt = nodes.iterator();
        ArrayList<Node> clusterNodes = new ArrayList<Node>();
        ArrayList<Edge> clusterEdges = new ArrayList<Edge>();
        while (nodeIt.hasNext()) {
            double bottom;
            double expectedTarget;
            double top;
            double poissonProb;
            DelaunayNode next = (DelaunayNode)nodeIt.next();
            SimpleFeature nextFeature = next.getFeature();
            Object baseObj = base.evaluate((Object)nextFeature);
            if (!(baseObj instanceof Number)) {
                throw new RuntimeException("Expression " + String.valueOf(base) + " must evaluate to a number on feature " + String.valueOf(nextFeature));
            }
            Object targetObj = target.evaluate((Object)nextFeature);
            if (!(targetObj instanceof Number)) {
                throw new RuntimeException("Expression " + String.valueOf(target) + " must evaluate to a number on feature " + String.valueOf(nextFeature));
            }
            double totalBase = ((Number)baseObj).doubleValue();
            double totalTarget = ((Number)targetObj).doubleValue();
            List<Object> newEdges = new ArrayList();
            ArrayList<DelaunayNode> newNodes = new ArrayList<DelaunayNode>();
            newNodes.add(next);
            if (distance == 1) {
                newEdges = next.getEdges();
                Iterator edgeIt = newEdges.iterator();
                ArrayList<DelaunayEdge> removals = new ArrayList<DelaunayEdge>();
                while (edgeIt.hasNext()) {
                    DelaunayEdge nextEdge = (DelaunayEdge)edgeIt.next();
                    if (nextEdge.getEuclideanDistance() > 30.0) {
                        removals.add(nextEdge);
                        continue;
                    }
                    DelaunayNode neighbor = (DelaunayNode)nextEdge.getOtherNode(next);
                    if (neighbor == null) {
                        throw new RuntimeException("We have a problem.  " + String.valueOf(next) + " and " + String.valueOf(neighbor) + " should be neighbors via " + String.valueOf(nextEdge) + ", but aren't.");
                    }
                    SimpleFeature neighborFeature = neighbor.getFeature();
                    newNodes.add(neighbor);
                    if (!(baseObj instanceof Number)) {
                        throw new RuntimeException("Expression " + String.valueOf(base) + " must evaluate to a number on feature " + String.valueOf(neighborFeature));
                    }
                    if (!(targetObj instanceof Number)) {
                        throw new RuntimeException("Expression " + String.valueOf(target) + " must evaluate to a number on feature " + String.valueOf(neighborFeature));
                    }
                    totalBase += ((Number)baseObj).doubleValue();
                    totalTarget += ((Number)targetObj).doubleValue();
                }
                newEdges.removeAll(removals);
            } else {
                for (int i = 0; i <= distance; ++i) {
                    Iterator nodeIt2 = newNodes.iterator();
                    ArrayList<DelaunayNode> nodesToAdd = new ArrayList<DelaunayNode>();
                    ArrayList<DelaunayEdge> edgesToAdd = new ArrayList<DelaunayEdge>();
                    while (nodeIt2.hasNext()) {
                        DelaunayNode next2 = (DelaunayNode)nodeIt2.next();
                        List<Edge> edges = next2.getEdges();
                        newEdges.addAll(edges);
                        for (DelaunayEdge delaunayEdge : edges) {
                            DelaunayNode farNode = (DelaunayNode)delaunayEdge.getOtherNode(next2);
                            if (newNodes.contains(farNode)) continue;
                            nodesToAdd.add(farNode);
                            edgesToAdd.add(delaunayEdge);
                        }
                    }
                    newNodes.addAll(nodesToAdd);
                    newEdges.addAll(edgesToAdd);
                }
                totalTarget = 0.0;
                totalBase = 0.0;
                for (DelaunayNode nextNode : newNodes) {
                    SimpleFeature nextFeature2 = nextNode.getFeature();
                    if (!(baseObj instanceof Number)) {
                        throw new RuntimeException("Expression " + String.valueOf(base) + " must evaluate to a number on feature " + String.valueOf(nextFeature2));
                    }
                    if (!(targetObj instanceof Number)) {
                        throw new RuntimeException("Expression " + String.valueOf(target) + " must evaluate to a number on feature " + String.valueOf(nextFeature2));
                    }
                    totalBase += ((Number)baseObj).doubleValue();
                    totalTarget += ((Number)targetObj).doubleValue();
                }
            }
            if (!((poissonProb = (top = Math.pow(Math.E, 0.0 - (expectedTarget = meanRate * totalBase)) * Math.pow(expectedTarget, totalTarget)) / (bottom = PoissonClusterer.fact((int)Math.round(totalTarget)))) < threshold)) continue;
            clusterNodes.addAll(newNodes);
            clusterEdges.addAll(newEdges);
        }
        return new BasicGraph(clusterNodes, clusterEdges);
    }

    private static double iterFact(int i, int f) {
        if (i == 0 || i == 1) {
            return f;
        }
        return PoissonClusterer.iterFact(i - 1, i * f);
    }

    public static double fact(int i) {
        return PoissonClusterer.iterFact(i, 1);
    }
}

