/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.traverse.basic;

import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.traverse.GraphIterator;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.GraphWalker;

public class BasicGraphTraversal
implements GraphTraversal {
    private Graph m_graph;
    private GraphWalker m_walker;
    private GraphIterator m_iterator;

    public BasicGraphTraversal(Graph graph, GraphWalker walker, GraphIterator iterator) {
        this.m_graph = graph;
        this.m_walker = walker;
        this.setIterator(iterator);
    }

    @Override
    public void setGraph(Graph graph) {
        this.m_graph = graph;
    }

    @Override
    public Graph getGraph() {
        return this.m_graph;
    }

    @Override
    public void setIterator(GraphIterator iterator) {
        this.m_iterator = iterator;
        this.m_iterator.setTraversal(this);
        this.m_iterator.init(this.m_graph, this);
    }

    @Override
    public GraphIterator getIterator() {
        return this.m_iterator;
    }

    @Override
    public void setWalker(GraphWalker walker) {
        this.m_walker = walker;
    }

    @Override
    public GraphWalker getWalker() {
        return this.m_walker;
    }

    @Override
    public void init() {
        this.m_graph.visitNodes(component -> {
            component.setVisited(false);
            component.setCount(0);
            return 0;
        });
    }

    @Override
    public void traverse() {
        Graphable current;
        block6: while ((current = this.m_iterator.next(this)) != null) {
            this.setVisited(current, true);
            switch (this.m_walker.visit(current, null)) {
                case 0: {
                    this.m_iterator.cont(current, this);
                    continue block6;
                }
                case 1: {
                    this.m_iterator.cont(current, this);
                    return;
                }
                case 2: {
                    this.m_iterator.killBranch(current, this);
                    continue block6;
                }
                case 3: {
                    break block6;
                }
                default: {
                    throw new IllegalStateException("Unrecognized return value from GraphWalker");
                }
            }
        }
        this.m_walker.finish();
    }

    @Override
    public void setVisited(Graphable g, boolean visited) {
        g.setVisited(visited);
    }

    @Override
    public boolean isVisited(Graphable g) {
        return g.isVisited();
    }
}

