/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.GraphVisitor;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;

public class BasicGraph
implements Graph,
Serializable {
    private transient Collection<Node> m_nodes;
    private transient Collection<Edge> m_edges;

    public BasicGraph() {
    }

    public BasicGraph(Collection<Node> nodes, Collection<Edge> edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
    }

    public void setNodes(Collection<Node> nodes) {
        this.m_nodes = nodes;
    }

    @Override
    public Collection<Node> getNodes() {
        return this.m_nodes;
    }

    public void setEdges(Collection<Edge> edges) {
        this.m_edges = edges;
    }

    @Override
    public Collection<Edge> getEdges() {
        return this.m_edges;
    }

    @Override
    public List<Node> queryNodes(GraphVisitor visitor) {
        return this.query(this.getNodes(), visitor);
    }

    public List<Edge> queryEdges(GraphVisitor visitor) {
        return this.query(this.getEdges(), visitor);
    }

    @Override
    public void visitNodes(GraphVisitor visitor) {
        this.visit(this.m_nodes, visitor);
    }

    @Override
    public void visitEdges(GraphVisitor visitor) {
        this.visit(this.m_edges, visitor);
    }

    @Override
    public List<Node> getNodesOfDegree(int n) {
        int degree = n;
        return this.queryNodes(component -> {
            if (((Node)component).getDegree() == degree) {
                return 1;
            }
            return 0;
        });
    }

    @Override
    public List<Node> getVisitedNodes(boolean visited) {
        return this.getVisited(this.getNodes(), visited);
    }

    @Override
    public List<Edge> getVisitedEdges(boolean visited) {
        return this.getVisited(this.getEdges(), visited);
    }

    public void initNodes() {
        for (Node node : this.m_nodes) {
            node.setVisited(false);
            node.setCount(0);
        }
    }

    public void initEdges() {
        for (Edge edge : this.m_edges) {
            edge.setVisited(false);
            edge.setCount(0);
        }
    }

    public String toString() {
        return "V=" + this.m_nodes.toString() + "\nE=" + this.m_edges.toString();
    }

    private List<? extends Graphable> query(Collection<? extends Graphable> components, GraphVisitor visitor) {
        ArrayList<Graphable> result = new ArrayList<Graphable>();
        block5: for (Graphable graphable : components) {
            switch (visitor.visit(graphable)) {
                case 1: {
                    result.add(graphable);
                    continue block5;
                }
                case 2: {
                    result.add(graphable);
                    return result;
                }
                case 0: {
                    continue block5;
                }
            }
        }
        return result;
    }

    private void visit(Collection<?> components, GraphVisitor visitor) {
        for (Object component : components) {
            visitor.visit((Graphable)component);
        }
    }

    private List<? extends Graphable> getVisited(Collection<? extends Graphable> components, boolean visited) {
        boolean isVisited = visited;
        return this.query(components, component -> {
            if (component.isVisited() == isVisited) {
                return 1;
            }
            return 0;
        });
    }
}

