/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.geopkg.GeoPkgDialect;
import org.geotools.geopkg.geom.GeoPkgGeomWriter;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.sqlite.SQLiteConfig;
import org.sqlite.javax.SQLiteConnectionPoolDataSource;

public class GeoPkgDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"geopkg", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", File.class, "Database", true, null, Collections.singletonMap("ext", "gpkg"));
    public static final DataAccessFactory.Param READ_ONLY = new DataAccessFactory.Param("read_only", Boolean.class, "Read only", false);
    public static final DataAccessFactory.Param CONTENTS_ONLY = new DataAccessFactory.Param("contents_only", Boolean.class, "Contents only", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param MEMORY_MAP_SIZE = new DataAccessFactory.Param("memory map size", Integer.class, "Max memory SQlite will memory map, in megabytes", false, null);
    File baseDirectory = null;
    GeoPkgGeomWriter.Configuration writerConfig;
    private static int sqlLiteConnectTimeout = 60000;

    public GeoPkgDataStoreFactory() {
        this.writerConfig = new GeoPkgGeomWriter.Configuration();
    }

    public GeoPkgDataStoreFactory(GeoPkgGeomWriter.Configuration writerConfig) {
        this.writerConfig = writerConfig;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    protected String getDatabaseID() {
        return "geopkg";
    }

    public String getDescription() {
        return "GeoPackage";
    }

    protected String getDriverClassName() {
        return "org.sqlite.JDBC";
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore, Map<String, ?> params) {
        try {
            Boolean contentsOnly = (Boolean)CONTENTS_ONLY.lookUp(params);
            GeoPkgDialect dialect = (GeoPkgDialect)this.createSQLDialect(dataStore);
            if (contentsOnly != null) {
                dialect.setContentsOnly(contentsOnly);
            }
            return dialect;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new GeoPkgDialect(dataStore, this.writerConfig);
    }

    protected String getValidationQuery() {
        return "SELECT 1";
    }

    protected String getJDBCUrl(Map<String, ?> params) throws IOException {
        File db = (File)DATABASE.lookUp(params);
        if (db.getPath().startsWith("file:")) {
            db = new File(db.getPath().substring(5));
        }
        if (this.baseDirectory != null && !db.isAbsolute()) {
            db = new File(this.baseDirectory, db.getPath());
        }
        return "jdbc:sqlite:" + db;
    }

    protected void setupParameters(Map<String, Object> parameters) {
        super.setupParameters(parameters);
        parameters.remove(GeoPkgDataStoreFactory.HOST.key);
        parameters.remove(GeoPkgDataStoreFactory.PORT.key);
        parameters.remove(GeoPkgDataStoreFactory.SCHEMA.key);
        parameters.remove(GeoPkgDataStoreFactory.USER.key);
        parameters.remove(GeoPkgDataStoreFactory.MAXCONN.key);
        parameters.remove(GeoPkgDataStoreFactory.MINCONN.key);
        parameters.remove(GeoPkgDataStoreFactory.MAXWAIT.key);
        parameters.remove(GeoPkgDataStoreFactory.VALIDATECONN.key);
        parameters.remove(GeoPkgDataStoreFactory.TEST_WHILE_IDLE.key);
        parameters.remove(GeoPkgDataStoreFactory.TIME_BETWEEN_EVICTOR_RUNS.key);
        parameters.remove(GeoPkgDataStoreFactory.MIN_EVICTABLE_TIME.key);
        parameters.remove(GeoPkgDataStoreFactory.EVICTOR_TESTS_PER_RUN.key);
        parameters.put(GeoPkgDataStoreFactory.DATABASE.key, DATABASE);
        parameters.put(GeoPkgDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(GeoPkgDataStoreFactory.READ_ONLY.key, READ_ONLY);
        parameters.put(GeoPkgDataStoreFactory.MEMORY_MAP_SIZE.key, MEMORY_MAP_SIZE);
    }

    public BasicDataSource createDataSource(Map<String, ?> params) throws IOException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.getDriverClassName());
        dataSource.setUrl(this.getJDBCUrl(params));
        GeoPkgDataStoreFactory.addConnectionProperties(dataSource, params);
        dataSource.setMinIdle(1);
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        return dataSource;
    }

    protected DataSource createDataSource(Map<String, ?> params, SQLDialect dialect) throws IOException {
        SQLiteConfig config = GeoPkgDataStoreFactory.setupSQLiteConfig(params);
        SQLiteConnectionPoolDataSource ds = new SQLiteConnectionPoolDataSource(config);
        ds.setUrl(this.getJDBCUrl(params));
        return ds;
    }

    private static SQLiteConfig setupSQLiteConfig(Map<String, ?> params) throws IOException {
        Object map;
        SQLiteConfig config = new SQLiteConfig();
        config.setSharedCache(true);
        config.enableLoadExtension(true);
        Object readOnly = READ_ONLY.lookUp(params);
        if (Boolean.TRUE.equals(readOnly)) {
            config.setPragma(SQLiteConfig.Pragma.SYNCHRONOUS, "OFF");
            config.setReadOnly(true);
        }
        if ((map = MEMORY_MAP_SIZE.lookUp(params)) instanceof Integer && (Integer)map >= 0) {
            int memoryMB = (Integer)map;
            config.setPragma(SQLiteConfig.Pragma.MMAP_SIZE, String.valueOf(memoryMB * 1024 * 1024));
        }
        config.setBusyTimeout(sqlLiteConnectTimeout);
        return config;
    }

    static void addConnectionProperties(BasicDataSource dataSource, Map<String, ?> configuration) throws IOException {
        SQLiteConfig config = GeoPkgDataStoreFactory.setupSQLiteConfig(configuration);
        for (Map.Entry<Object, Object> e : config.toProperties().entrySet()) {
            dataSource.addConnectionProperty((String)e.getKey(), (String)e.getValue());
        }
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map<String, ?> params) throws IOException {
        dataStore.setDatabaseSchema(null);
        return dataStore;
    }

    public static void setSqlLiteConnectTimeout(int sqlLiteConnectTimeout) {
        GeoPkgDataStoreFactory.sqlLiteConnectTimeout = sqlLiteConnectTimeout;
    }
}

