/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jackson.datatype.projjson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.referencing.FactoryException;
import org.geotools.jackson.datatype.projjson.ProjJSONModule;
import org.geotools.jackson.datatype.projjson.model.CoordinateReferenceSystem;
import org.geotools.jackson.datatype.projjson.model.GeographicCRS;
import org.geotools.jackson.datatype.projjson.model.Identifier;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class ProjJSONHelper {
    private static final Logger LOGGER = Logger.getLogger(ProjJSONHelper.class.getName());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new ProjJSONModule());

    public static org.geotools.api.referencing.crs.CoordinateReferenceSystem parseCRS(String projjson) {
        if (projjson == null || projjson.trim().isEmpty()) {
            return DefaultGeographicCRS.WGS84;
        }
        try {
            CoordinateReferenceSystem modelCrs = (CoordinateReferenceSystem)OBJECT_MAPPER.readValue(projjson, CoordinateReferenceSystem.class);
            return ProjJSONHelper.convertToGeoToolsCRS(modelCrs);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to parse PROJJSON: " + e.getMessage(), e);
            return DefaultGeographicCRS.WGS84;
        }
    }

    private static org.geotools.api.referencing.crs.CoordinateReferenceSystem convertToGeoToolsCRS(CoordinateReferenceSystem modelCrs) {
        Identifier identifier;
        GeographicCRS geographicCRS;
        String name;
        if (modelCrs instanceof GeographicCRS && "WGS 84".equals(name = (geographicCRS = (GeographicCRS)modelCrs).getName())) {
            return DefaultGeographicCRS.WGS84;
        }
        Identifier id = modelCrs.getId();
        if (id instanceof Identifier && "EPSG".equals((identifier = id).getAuthority())) {
            try {
                return CRS.decode((String)("EPSG:" + identifier.getCode()), (boolean)true);
            }
            catch (FactoryException e) {
                LOGGER.log(Level.WARNING, "Failed to decode EPSG code: " + e.getMessage(), e);
            }
        }
        LOGGER.log(Level.WARNING, "Couldn't convert PROJJSON CRS: " + modelCrs.getName() + ", defaulting to WGS84");
        return DefaultGeographicCRS.WGS84;
    }
}

