/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jackson.datatype.projjson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.geotools.jackson.datatype.projjson.model.BoundCRS;
import org.geotools.jackson.datatype.projjson.model.CompoundCRS;
import org.geotools.jackson.datatype.projjson.model.CoordinateReferenceSystem;
import org.geotools.jackson.datatype.projjson.model.GeographicCRS;
import org.geotools.jackson.datatype.projjson.model.ProjectedCRS;
import org.geotools.jackson.datatype.projjson.model.Transformation;

public class CoordinateReferenceSystemDeserializer
extends StdDeserializer<CoordinateReferenceSystem> {
    private static final long serialVersionUID = 1L;

    public CoordinateReferenceSystemDeserializer() {
        super(CoordinateReferenceSystem.class);
    }

    public CoordinateReferenceSystem deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode root = (JsonNode)mapper.readTree(p);
        if (root.has("type")) {
            String type;
            switch (type = root.get("type").asText()) {
                case "GeographicCRS": {
                    return (CoordinateReferenceSystem)mapper.treeToValue((TreeNode)root, GeographicCRS.class);
                }
                case "ProjectedCRS": {
                    return (CoordinateReferenceSystem)mapper.treeToValue((TreeNode)root, ProjectedCRS.class);
                }
                case "CompoundCRS": {
                    return (CoordinateReferenceSystem)mapper.treeToValue((TreeNode)root, CompoundCRS.class);
                }
                case "BoundCRS": {
                    return (CoordinateReferenceSystem)mapper.treeToValue((TreeNode)root, BoundCRS.class);
                }
                case "Transformation": {
                    return (CoordinateReferenceSystem)mapper.treeToValue((TreeNode)root, Transformation.class);
                }
            }
            throw new IOException("Unknown CRS type: " + type);
        }
        throw new IOException("Missing required 'type' field in CRS JSON");
    }
}

