/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geoparquet;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.geotools.data.geoparquet.GeoParquetDataStoreFactory;

class GeoParquetConfig {
    private URI targetUri;
    private Integer maxHiveDepth;

    public GeoParquetConfig(URI uri, Integer maxHiveDepth) {
        this.targetUri = uri;
        this.maxHiveDepth = maxHiveDepth;
    }

    public static GeoParquetConfig valueOf(Map<String, ?> params) throws IOException {
        URI uri = GeoParquetConfig.lookupURI(params);
        Integer maxHiveDepth = (Integer)GeoParquetDataStoreFactory.MAX_HIVE_DEPTH.lookUp(params);
        if (maxHiveDepth != null && maxHiveDepth < 0) {
            throw new IOException(GeoParquetDataStoreFactory.MAX_HIVE_DEPTH.key + " is negative: " + maxHiveDepth);
        }
        return new GeoParquetConfig(uri, maxHiveDepth);
    }

    private static URI lookupURI(Map<String, ?> params) throws IOException {
        String lookUp = (String)Objects.requireNonNull(GeoParquetDataStoreFactory.URI_PARAM.lookUp(params));
        try {
            return new URI(lookUp);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public URI getTargetUri() {
        return this.targetUri;
    }

    public Integer getMaxHiveDepth() {
        return this.maxHiveDepth;
    }
}

