/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jackson.datatype.geoparquet;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.geotools.jackson.datatype.geoparquet.Covering;
import org.geotools.jackson.datatype.projjson.model.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Envelope;

public class Geometry {
    @JsonProperty(value="encoding", required=true)
    protected String encoding;
    @JsonProperty(value="geometry_types", required=true)
    protected List<String> geometryTypes;
    @JsonProperty(value="crs")
    protected CoordinateReferenceSystem crs;
    @JsonProperty(value="edges")
    protected String edges;
    @JsonProperty(value="orientation")
    protected String orientation;
    @JsonProperty(value="bbox")
    protected List<Double> bbox;
    @JsonProperty(value="epoch")
    protected Double epoch;
    @JsonProperty(value="covering")
    protected Covering covering;

    public Envelope bounds() {
        List<Double> bb = this.getBbox();
        if (bb == null || bb.size() < 4) {
            return new Envelope();
        }
        double minx = bb.get(0);
        double miny = bb.get(1);
        double maxx = bb.get(bb.size() == 6 ? 4 : 2);
        double maxy = bb.get(bb.size() == 6 ? 5 : 3);
        return new Envelope(minx, maxx, miny, maxy);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public List<String> getGeometryTypes() {
        return this.geometryTypes;
    }

    public void setGeometryTypes(List<String> geometryTypes) {
        this.geometryTypes = geometryTypes;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public String getEdges() {
        return this.edges;
    }

    public void setEdges(String edges) {
        this.edges = edges;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public List<Double> getBbox() {
        return this.bbox;
    }

    public void setBbox(List<Double> bbox) {
        this.bbox = bbox;
    }

    public Double getEpoch() {
        return this.epoch;
    }

    public void setEpoch(Double epoch) {
        this.epoch = epoch;
    }

    public Covering getCovering() {
        return this.covering;
    }

    public void setCovering(Covering covering) {
        this.covering = covering;
    }
}

