/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jackson.datatype.geoparquet;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.geotools.jackson.datatype.geoparquet.GeoParquetMetadataV1_1_0;
import org.geotools.jackson.datatype.geoparquet.GeoParquetMetadataV1_2_0Dev;
import org.geotools.jackson.datatype.geoparquet.GeoParquetModule;
import org.geotools.jackson.datatype.geoparquet.Geometry;
import org.locationtech.jts.geom.Envelope;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="version", defaultImpl=GeoParquetMetadataV1_1_0.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=GeoParquetMetadataV1_1_0.class, name="1.1.0"), @JsonSubTypes.Type(value=GeoParquetMetadataV1_2_0Dev.class, name="1.2.0-dev")})
public abstract class GeoParquetMetadata {
    private static final ObjectMapper objectMapper = GeoParquetModule.createObjectMapper();
    @JsonProperty(value="version", required=true)
    protected String version;
    @JsonProperty(value="primary_column", required=true)
    protected String primaryColumn;
    @JsonProperty(value="columns", required=true)
    protected Map<String, Geometry> columns;

    public static GeoParquetMetadata readValue(String geo) throws IOException {
        return (GeoParquetMetadata)objectMapper.readValue(geo, GeoParquetMetadata.class);
    }

    public Envelope bounds() {
        return Optional.ofNullable(this.columns.get(this.primaryColumn)).map(Geometry::bounds).orElseGet(Envelope::new);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPrimaryColumn() {
        return this.primaryColumn;
    }

    public void setPrimaryColumn(String primaryColumn) {
        this.primaryColumn = primaryColumn;
    }

    public Optional<Geometry> getColumn(String column) {
        return Optional.ofNullable(this.columns).map(cols -> (Geometry)cols.get(column));
    }

    public Map<String, Geometry> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<String, Geometry> columns) {
        this.columns = columns;
    }
}

