/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geoparquet;

import java.io.IOException;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.data.geoparquet.ForwardingFeatureSource;
import org.geotools.data.geoparquet.OverridingFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;

class OverridingFeatureSource
extends ForwardingFeatureSource {
    private SimpleFeatureType overridingType;
    private DataStore dataStore;

    public OverridingFeatureSource(SimpleFeatureSource delegate, DataStore overridingStore, SimpleFeatureType overridingType) {
        super(delegate);
        this.dataStore = overridingStore;
        this.overridingType = overridingType;
    }

    @Override
    public DataAccess<SimpleFeatureType, SimpleFeature> getDataStore() {
        return this.dataStore;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.overridingType;
    }

    @Override
    public SimpleFeatureCollection getFeatures() throws IOException {
        return new OverridingFeatureCollection(this.delegate.getFeatures(), this.overridingType);
    }

    @Override
    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return new OverridingFeatureCollection(this.delegate.getFeatures(filter), this.overridingType);
    }

    @Override
    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        return new OverridingFeatureCollection(this.delegate.getFeatures(query), this.overridingType);
    }
}

