/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geoparquet;

import java.util.NoSuchElementException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.geoparquet.GeoParquetDialect;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.DecoratingFeature;

class OverridingFeatureCollection
extends ReTypingFeatureCollection {
    private SimpleFeatureType featureType;

    protected OverridingFeatureCollection(SimpleFeatureCollection delegate, SimpleFeatureType featureType) {
        super(delegate, featureType);
        this.featureType = featureType;
    }

    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    public SimpleFeatureIterator features() {
        GeoParquetDialect.CURRENT_TYPENAME.set(this.featureType.getTypeName());
        try {
            OverridingFeatureIterator overridingFeatureIterator = new OverridingFeatureIterator(this.delegate.features(), this.featureType);
            return overridingFeatureIterator;
        }
        finally {
            GeoParquetDialect.CURRENT_TYPENAME.remove();
        }
    }

    static class OverridingFeature
    extends DecoratingFeature {
        private SimpleFeatureType featureTypeOverride;

        public OverridingFeature(SimpleFeature feature, SimpleFeatureType featureType) {
            super(feature);
            this.featureTypeOverride = featureType;
        }

        public SimpleFeatureType getFeatureType() {
            return this.featureTypeOverride;
        }
    }

    static class OverridingFeatureIterator
    implements SimpleFeatureIterator {
        private SimpleFeatureIterator features;
        private SimpleFeatureType featureType;

        public OverridingFeatureIterator(SimpleFeatureIterator features, SimpleFeatureType featureType) {
            this.features = features;
            this.featureType = featureType;
        }

        public boolean hasNext() {
            return this.features.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature feature = (SimpleFeature)this.features.next();
            return new OverridingFeature(feature, this.featureType);
        }

        public void close() {
            this.features.close();
        }
    }
}

