/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geoparquet;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.geoparquet.ForwardingDataStore;
import org.geotools.data.geoparquet.GeoParquetDialect;
import org.geotools.data.geoparquet.OverridingFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.JDBCDataStore;

public class GeoparquetDataStore
extends ForwardingDataStore<JDBCDataStore>
implements DataStore {
    public GeoparquetDataStore(JDBCDataStore delegate) {
        super(delegate);
    }

    @Override
    public String[] getTypeNames() throws IOException {
        return (String[])this.getSQLDialect().getTypeNames().toArray(String[]::new);
    }

    @Override
    public List<Name> getNames() throws IOException {
        String namespaceURI = ((JDBCDataStore)this.delegate).getNamespaceURI();
        return Arrays.stream(this.getTypeNames()).map(localName -> new NameImpl(namespaceURI, localName)).collect(Collectors.toList());
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return this.getSchema((Name)new NameImpl(((JDBCDataStore)this.delegate).getNamespaceURI(), typeName));
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        return this.getFeatureSource((Name)new NameImpl(((JDBCDataStore)this.delegate).getNamespaceURI(), typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        GeoParquetDialect.CURRENT_TYPENAME.set(name.getLocalPart());
        try {
            this.getSQLDialect().ensureViewExists(name.getLocalPart());
            SimpleFeatureType schema = ((JDBCDataStore)this.delegate).getSchema(name);
            SimpleFeatureType simpleFeatureType = this.getSQLDialect().fixGeometryTypes(schema);
            return simpleFeatureType;
        }
        finally {
            GeoParquetDialect.CURRENT_TYPENAME.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        GeoParquetDialect.CURRENT_TYPENAME.set(typeName.getLocalPart());
        try {
            this.getSQLDialect().ensureViewExists(typeName.getLocalPart());
            SimpleFeatureSource featureSource = ((JDBCDataStore)this.delegate).getFeatureSource(typeName);
            SimpleFeatureType geometryTypeNarrowedSchema = this.getSQLDialect().fixGeometryTypes((SimpleFeatureType)featureSource.getSchema());
            OverridingFeatureSource overridingFeatureSource = new OverridingFeatureSource(featureSource, this, geometryTypeNarrowedSchema);
            return overridingFeatureSource;
        }
        finally {
            GeoParquetDialect.CURRENT_TYPENAME.remove();
        }
    }

    GeoParquetDialect getSQLDialect() {
        return (GeoParquetDialect)((JDBCDataStore)this.delegate).getSQLDialect();
    }
}

