/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geoparquet;

import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.data.duckdb.DuckDBFilterToSQL;

public class GeoParquetFilterToSQL
extends DuckDBFilterToSQL {
    public String toString() {
        return "GeoParquetFilterToSQL[" + this.out + "]";
    }

    @Override
    protected Object visitBBOX(BBOX filter, Expression leftExp, Expression rightExpt, Object extraData) {
        BoundingBox bounds = filter.getBounds();
        double xmin = bounds.getMinX();
        double xmax = bounds.getMaxX();
        double ymin = bounds.getMinY();
        double ymax = bounds.getMaxY();
        this.write("bbox.xmin <= %f and bbox.xmax >= %f and bbox.ymin <= %f and bbox.ymax >= %f", xmax, xmin, ymax, ymin);
        return extraData;
    }
}

