/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geoparquet;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import org.geotools.api.data.DataAccessFactory;

final class GeoParquetDatabaseUtils {
    public static String getJDBCUrl(Map<String, ?> params, DataAccessFactory.Param[] parametersInfo) throws IOException {
        String configString = GeoParquetDatabaseUtils.buildConfigString(params, parametersInfo);
        String hash = GeoParquetDatabaseUtils.computeConfigHash(configString);
        return "jdbc:duckdb::memory:" + hash;
    }

    private GeoParquetDatabaseUtils() {
    }

    private static String buildConfigString(Map<String, ?> params, DataAccessFactory.Param[] parametersInfo) throws IOException {
        StringBuilder configKey = new StringBuilder();
        Arrays.sort(parametersInfo, (p1, p2) -> p1.key.compareTo(p2.key));
        for (DataAccessFactory.Param param : parametersInfo) {
            String key = param.key;
            Object value = param.lookUp(params);
            configKey.append(key).append('=');
            if (value != null) {
                configKey.append(value.toString());
            } else {
                configKey.append("null");
            }
            configKey.append(';');
        }
        return configKey.toString();
    }

    private static String computeConfigHash(String configString) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to create SHA-256 hash for " + configString);
        }
        byte[] digest = md.digest(configString.getBytes(StandardCharsets.UTF_8));
        return GeoParquetDatabaseUtils.bytesToHex(digest);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

