/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geoparquet;

import java.io.IOException;
import java.util.Map;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.data.duckdb.AbstractDuckDBDataStoreFactory;
import org.geotools.data.duckdb.ParamBuilder;
import org.geotools.data.geoparquet.GeoParquetConfig;
import org.geotools.data.geoparquet.GeoParquetDatabaseUtils;
import org.geotools.data.geoparquet.GeoParquetDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;

class GeoParquetDataStoreFactoryDelegate
extends AbstractDuckDBDataStoreFactory
implements DataStoreFactorySpi {
    static final String GEOPARQUET = "geoparquet";
    public static final DataAccessFactory.Param DBTYPE = new ParamBuilder("dbtype").type(String.class).title("DataStore type identifier").required(true).defaultValue("geoparquet").programLevel().build();
    public static final DataAccessFactory.Param URI_PARAM = new ParamBuilder("uri").type(String.class).description("URI to GeoParquet local or remote file").required(true).userLevel().build();
    public static final DataAccessFactory.Param MAX_HIVE_DEPTH = new ParamBuilder("max_hive_depth").type(Integer.class).title("Max Hive partition depth").description("Max number Hive partitions to use when resolving feature types").required(false).defaultValue(null).advancedLevel().build();
    public static final DataAccessFactory.Param NAMESPACE = AbstractDuckDBDataStoreFactory.NAMESPACE;
    public static final DataAccessFactory.Param FETCHSIZE = AbstractDuckDBDataStoreFactory.FETCHSIZE;
    public static final DataAccessFactory.Param SCREENMAP = AbstractDuckDBDataStoreFactory.SCREENMAP;
    public static final DataAccessFactory.Param SIMPLIFY = AbstractDuckDBDataStoreFactory.SIMPLIFY;

    GeoParquetDataStoreFactoryDelegate() {
    }

    protected String getDatabaseID() {
        return GEOPARQUET;
    }

    public String getDisplayName() {
        return "GeoParquet";
    }

    public String getDescription() {
        return "GeoParquet format data files (*.parquet)";
    }

    @Override
    protected void addDatabaseSpecificParameters(Map<String, Object> parameters) {
        parameters.put(GeoParquetDataStoreFactoryDelegate.DBTYPE.key, DBTYPE);
        parameters.put(GeoParquetDataStoreFactoryDelegate.URI_PARAM.key, URI_PARAM);
        parameters.put(GeoParquetDataStoreFactoryDelegate.MAX_HIVE_DEPTH.key, MAX_HIVE_DEPTH);
    }

    protected GeoParquetDialect createSQLDialect(JDBCDataStore dataStore, Map<String, ?> params) {
        return new GeoParquetDialect(dataStore);
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected JDBCDataStore setupDataStore(JDBCDataStore dataStore, Map<String, ?> params) throws IOException {
        GeoParquetDialect dialect = (GeoParquetDialect)dataStore.getSQLDialect();
        dataStore.setPrimaryKeyFinder(dialect.getPrimaryKeyFinder());
        GeoParquetConfig config = GeoParquetConfig.valueOf(params);
        dialect.initialize(config);
        return dataStore;
    }

    @Override
    protected String getJDBCUrl(Map<String, ?> params) throws IOException {
        return GeoParquetDatabaseUtils.getJDBCUrl(params, this.getParametersInfo());
    }
}

