/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.duckdb.datasource;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.duckdb.datasource.DuckdbConnectionFactory;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.util.logging.Logging;

public class DuckdbDataSource
extends BasicDataSource
implements ManageableDataSource {
    private DuckdbConnectionFactory duckdbConnectionFactory;
    private List<String> databaseInitSqls;

    public DuckdbDataSource(List<String> databaseInitSqls) {
        this.databaseInitSqls = Objects.requireNonNull(databaseInitSqls);
        super.setDriverClassName("org.duckdb.DuckDBDriver");
    }

    protected DuckdbConnectionFactory createConnectionFactory() throws SQLException {
        Driver driver = DriverManager.getDriver(Objects.requireNonNull(this.getUrl(), "url is null"));
        String validationQuery = this.getValidationQuery();
        if (validationQuery == null) {
            this.setTestOnBorrow(false);
            this.setTestOnReturn(false);
            this.setTestWhileIdle(false);
        }
        String user = this.getUsername();
        String pwd = this.getPassword();
        if (user != null) {
            this.addConnectionProperty("user", user);
        }
        if (pwd != null) {
            this.addConnectionProperty("password", pwd);
        }
        this.duckdbConnectionFactory = new DuckdbConnectionFactory(driver, this.url, this.connectionProperties, this.databaseInitSqls);
        return this.duckdbConnectionFactory;
    }

    public synchronized void close() throws SQLException {
        if (this.duckdbConnectionFactory != null) {
            this.duckdbConnectionFactory.close();
        }
        super.close();
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logging.getLogger(((Object)((Object)this)).getClass()).getParent();
    }
}

