/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.duckdb;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.geotools.api.filter.NativeFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.LengthFunction;
import org.geotools.filter.function.DateDifferenceFunction;
import org.geotools.filter.function.FilterFunction_area;
import org.geotools.filter.function.FilterFunction_buffer;
import org.geotools.filter.function.FilterFunction_equalTo;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.function.FilterFunction_strEndsWith;
import org.geotools.filter.function.FilterFunction_strEqualsIgnoreCase;
import org.geotools.filter.function.FilterFunction_strIndexOf;
import org.geotools.filter.function.FilterFunction_strLength;
import org.geotools.filter.function.FilterFunction_strReplace;
import org.geotools.filter.function.FilterFunction_strStartsWith;
import org.geotools.filter.function.FilterFunction_strSubstring;
import org.geotools.filter.function.FilterFunction_strSubstringStart;
import org.geotools.filter.function.FilterFunction_strToLowerCase;
import org.geotools.filter.function.FilterFunction_strToUpperCase;
import org.geotools.filter.function.FilterFunction_strTrim;
import org.geotools.filter.function.FilterFunction_strTrim2;
import org.geotools.filter.function.InArrayFunction;
import org.geotools.filter.function.math.FilterFunction_abs;
import org.geotools.filter.function.math.FilterFunction_abs_2;
import org.geotools.filter.function.math.FilterFunction_abs_3;
import org.geotools.filter.function.math.FilterFunction_abs_4;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.filter.function.math.FilterFunction_floor;
import org.geotools.geometry.jts.JTS;
import org.geotools.jdbc.SQLDialect;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;

public class DuckDBFilterToSQL
extends FilterToSQL {
    static FilterCapabilities createFilterCapabilities(FilterCapabilities caps, boolean encodeFunctions) {
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        caps.addType(FilterFunction_area.class);
        if (encodeFunctions) {
            caps.addType(FilterFunction_strConcat.class);
            caps.addType(FilterFunction_strEndsWith.class);
            caps.addType(FilterFunction_strStartsWith.class);
            caps.addType(FilterFunction_strEqualsIgnoreCase.class);
            caps.addType(FilterFunction_strIndexOf.class);
            caps.addType(FilterFunction_strLength.class);
            caps.addType(LengthFunction.class);
            caps.addType(FilterFunction_strToLowerCase.class);
            caps.addType(FilterFunction_strToUpperCase.class);
            caps.addType(FilterFunction_strReplace.class);
            caps.addType(FilterFunction_strSubstring.class);
            caps.addType(FilterFunction_strSubstringStart.class);
            caps.addType(FilterFunction_strTrim.class);
            caps.addType(FilterFunction_strTrim2.class);
            caps.addType(FilterFunction_abs.class);
            caps.addType(FilterFunction_abs_2.class);
            caps.addType(FilterFunction_abs_3.class);
            caps.addType(FilterFunction_abs_4.class);
            caps.addType(FilterFunction_ceil.class);
            caps.addType(FilterFunction_floor.class);
            caps.addType(DateDifferenceFunction.class);
            caps.addType(InArrayFunction.class);
            caps.addType(FilterFunction_equalTo.class);
            caps.addType(FilterFunction_buffer.class);
        }
        caps.addType(NativeFilter.class);
        return caps;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = super.createFilterCapabilities();
        return DuckDBFilterToSQL.createFilterCapabilities(caps, false);
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry g = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        this.visitLiteralGeometry(g);
    }

    protected void visitLiteralGeometry(Geometry g) throws IOException {
        if (g instanceof LinearRing) {
            g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
        }
        this.write("ST_GeomFromText('%s')", g.toText());
    }

    protected void visitLiteralBoundingBox(BoundingBox bounds) throws IOException {
        this.visitLiteralGeometry((Geometry)JTS.toGeometry((BoundingBox)bounds));
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        return this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression leftExp, Expression rightExpt, Object extraData) {
        String stFunction;
        if (filter instanceof DistanceBufferOperator) {
            return this.visitDistanceBufferOperator((DistanceBufferOperator)filter, leftExp, rightExpt, extraData);
        }
        if (filter instanceof BBOX) {
            return this.visitBBOX((BBOX)filter, leftExp, rightExpt, extraData);
        }
        if (filter instanceof Contains) {
            stFunction = "ST_Contains";
        } else if (filter instanceof Crosses) {
            stFunction = "ST_Crosses";
        } else if (filter instanceof Disjoint) {
            stFunction = "ST_Disjoint";
        } else if (filter instanceof Equals) {
            stFunction = "ST_Equals";
        } else if (filter instanceof Intersects) {
            stFunction = "ST_Intersects";
        } else if (filter instanceof Overlaps) {
            stFunction = "ST_Overlaps";
        } else if (filter instanceof Touches) {
            stFunction = "ST_Touches";
        } else if (filter instanceof Within) {
            stFunction = "ST_Within";
        } else {
            throw new IllegalArgumentException("Unknown operator: " + filter);
        }
        this.write("%s(", stFunction);
        leftExp.accept((ExpressionVisitor)this, extraData);
        this.write(", ", new Object[0]);
        rightExpt.accept((ExpressionVisitor)this, extraData);
        this.write(")", new Object[0]);
        return extraData;
    }

    protected Object visitBBOX(BBOX filter, Expression leftExp, Expression rightExpt, Object extraData) {
        this.write("ST_Intersects(", new Object[0]);
        leftExp.accept((ExpressionVisitor)this, extraData);
        this.write(",", new Object[0]);
        rightExpt.accept((ExpressionVisitor)this, extraData);
        this.write(")", new Object[0]);
        return extraData;
    }

    protected Object visitDistanceBufferOperator(DistanceBufferOperator filter, Expression leftExp, Expression rightExpt, Object extraData) {
        String dFunc;
        double distance = this.getDistanceInNativeUnits(filter);
        if (filter instanceof DWithin) {
            dFunc = "ST_DWithin";
        } else if (filter instanceof Beyond) {
            dFunc = "ST_Beyond";
        } else {
            throw new IllegalArgumentException("Unknown distance operator");
        }
        this.write("%s(", dFunc);
        leftExp.accept((ExpressionVisitor)this, extraData);
        this.write(", ", new Object[0]);
        rightExpt.accept((ExpressionVisitor)this, extraData);
        this.write(", %f)", distance);
        return extraData;
    }

    protected void write(String fmt, Object ... args) {
        try {
            this.out.write(String.format(fmt, args));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

