/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.duckdb;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.data.duckdb.AbstractDuckDBDataStoreFactory;
import org.geotools.data.duckdb.DuckDBDialect;
import org.geotools.data.duckdb.ParamBuilder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;

public class DuckDBDataStoreFactory
extends AbstractDuckDBDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param IN_MEMORY = new ParamBuilder("memory").type(Boolean.class).title("Use in-memory DuckDB database").description("Use in-memory DuckDB database. Required if 'database' is not provided.").required(false).defaultValue(false).build();
    public static final DataAccessFactory.Param DB_PATH = new ParamBuilder("database").type(String.class).description("Path to DuckDB database file. Required if it's not an in-memory database.").required(false).build();
    protected File baseDirectory = null;

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public String getDisplayName() {
        return "DuckDB";
    }

    public String getDescription() {
        return "DuckDB";
    }

    @Override
    protected void addDatabaseSpecificParameters(Map<String, Object> parameters) {
        parameters.put(DuckDBDataStoreFactory.IN_MEMORY.key, IN_MEMORY);
        parameters.put(DuckDBDataStoreFactory.DB_PATH.key, DB_PATH);
    }

    protected String getDatabaseID() {
        return "duckdb";
    }

    @Override
    protected String getJDBCUrl(Map<String, ?> params) throws IOException {
        String database = (String)DB_PATH.lookUp(params);
        if (Boolean.TRUE.equals(IN_MEMORY.lookUp(params)) || database == null) {
            return "jdbc:duckdb:";
        }
        if (this.baseDirectory == null) {
            return "jdbc:duckdb:" + database;
        }
        String location = !new File(database).isAbsolute() ? new File(this.baseDirectory, database).getAbsolutePath() : database;
        return "jdbc:duckdb:" + location;
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new DuckDBDialect(dataStore);
    }

    @Override
    protected JDBCDataStore setupDataStore(JDBCDataStore dataStore, Map<String, ?> params) throws IOException {
        return dataStore;
    }
}

