/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.duckdb;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.data.duckdb.DuckDBDialect;
import org.geotools.data.duckdb.ParamBuilder;
import org.geotools.data.duckdb.datasource.DuckdbDataSource;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public abstract class AbstractDuckDBDataStoreFactory
extends JDBCDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param NAMESPACE = JDBCDataStoreFactory.NAMESPACE;
    public static final DataAccessFactory.Param FETCHSIZE = JDBCDataStoreFactory.FETCHSIZE;
    public static final DataAccessFactory.Param SCREENMAP = new ParamBuilder("screenmap").type(Boolean.class).title("Support rendering screenmap").description("Enables the rendering aid used to avoid painting tiny features over and over in the same pixel").required(false).defaultValue(true).advancedLevel().build();
    public static final DataAccessFactory.Param SIMPLIFY = new ParamBuilder("simplification").type(Boolean.class).title("Support on the fly geometry simplification").description("When enabled, operations such as map rendering will pass a hint that will enable the usage of a simplification function").required(false).defaultValue(true).build();

    protected abstract void addDatabaseSpecificParameters(Map<String, Object> var1);

    protected abstract String getJDBCUrl(Map<String, ?> var1) throws IOException;

    protected abstract JDBCDataStore setupDataStore(JDBCDataStore var1, Map<String, ?> var2) throws IOException;

    protected void setupParameters(Map<String, Object> parameters) {
        parameters.put(AbstractDuckDBDataStoreFactory.NAMESPACE.key, NAMESPACE);
        this.addDatabaseSpecificParameters(parameters);
        parameters.put(AbstractDuckDBDataStoreFactory.SIMPLIFY.key, SIMPLIFY);
        parameters.put(AbstractDuckDBDataStoreFactory.SCREENMAP.key, SCREENMAP);
        parameters.put(AbstractDuckDBDataStoreFactory.FETCHSIZE.key, FETCHSIZE);
    }

    protected final String getDriverClassName() {
        return "org.duckdb.DuckDBDriver";
    }

    protected BasicDataSource createDataSource(Map<String, ?> params, SQLDialect dialect) throws IOException {
        DuckDBDialect duckDBDialect = (DuckDBDialect)dialect;
        List<String> databaseInitSqls = duckDBDialect.getDatabaseInitSql();
        DuckdbDataSource dataSource = new DuckdbDataSource(databaseInitSqls);
        dataSource.setUrl(this.getJDBCUrl(params));
        dataSource.setDriverClassName(this.getDriverClassName());
        dataSource.addConnectionProperty("jdbc_stream_results", "true");
        dataSource.setMinIdle(1);
        dataSource.setMaxActive(2 * Runtime.getRuntime().availableProcessors());
        return dataSource;
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map<String, ?> params) throws IOException {
        DuckDBDialect dialect = (DuckDBDialect)dataStore.getSQLDialect();
        Boolean screenmap = (Boolean)SCREENMAP.lookUp(params);
        dialect.setScreenMapEnabled(screenmap == null || screenmap != false);
        Boolean simplify = (Boolean)SIMPLIFY.lookUp(params);
        dialect.setSimplifyEnabled(simplify == null || simplify != false);
        return this.setupDataStore(dataStore, params);
    }

    protected String getValidationQuery() {
        return "SELECT 1";
    }
}

