/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geoparquet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.api.referencing.FactoryException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jackson.datatype.geoparquet.GeoParquetMetadata;
import org.geotools.jackson.datatype.geoparquet.GeoParquetModule;
import org.geotools.jackson.datatype.geoparquet.Geometry;
import org.geotools.jackson.datatype.projjson.ProjJSONHelper;
import org.geotools.jackson.datatype.projjson.model.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.Puntal;

public class GeoparquetDatasetMetadata {
    private static final ObjectMapper MAPPER = GeoParquetModule.createObjectMapper();
    private static final Map<String, Class<? extends org.locationtech.jts.geom.Geometry>> GEOMNAME_TO_TYPE = Map.of("Point", Point.class, "MultiPoint", MultiPoint.class, "LineString", LineString.class, "MultiLineString", MultiLineString.class, "Polygon", Polygon.class, "MultiPolygon", MultiPolygon.class, "LinearRing", LinearRing.class, "GeometryCollection", GeometryCollection.class, "Geometry", org.locationtech.jts.geom.Geometry.class);
    private Map<String, GeoParquetMetadata> md;
    private Map<String, Set<Class<? extends org.locationtech.jts.geom.Geometry>>> geometryTypes = new ConcurrentHashMap<String, Set<Class<? extends org.locationtech.jts.geom.Geometry>>>();

    public GeoparquetDatasetMetadata(Map<String, GeoParquetMetadata> md) {
        this.md = Map.copyOf(Objects.requireNonNull(md));
    }

    public boolean isEmpty() {
        return this.md.isEmpty();
    }

    public Optional<String> getPrimaryColumnName() {
        return this.sample().map(GeoParquetMetadata::getPrimaryColumn);
    }

    public Optional<Geometry> getPrimaryColumn() {
        return this.getPrimaryColumnName().flatMap(this::getColumn);
    }

    public Optional<Geometry> getColumn(String column) {
        return this.sample().flatMap(md -> md.getColumn(column));
    }

    public Class<? extends org.locationtech.jts.geom.Geometry> getNarrowedGeometryType(String column) {
        Set<Class<? extends org.locationtech.jts.geom.Geometry>> types = this.getGeometryTypes(column);
        if (types.isEmpty()) {
            return org.locationtech.jts.geom.Geometry.class;
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        if (types.contains(org.locationtech.jts.geom.Geometry.class)) {
            return org.locationtech.jts.geom.Geometry.class;
        }
        boolean multi = false;
        boolean point = false;
        boolean line = false;
        boolean poly = false;
        for (Class<? extends org.locationtech.jts.geom.Geometry> c : types) {
            if (GeometryCollection.class.isAssignableFrom(c)) {
                multi = true;
            }
            if (Puntal.class.isAssignableFrom(c)) {
                point = true;
                continue;
            }
            if (Lineal.class.isAssignableFrom(c)) {
                line = true;
                continue;
            }
            if (!Polygonal.class.isAssignableFrom(c)) continue;
            poly = true;
        }
        int baseTypeCount = (point ? 1 : 0) + (line ? 1 : 0) + (poly ? 1 : 0);
        if (baseTypeCount > 1) {
            return multi && types.contains(GeometryCollection.class) ? GeometryCollection.class : org.locationtech.jts.geom.Geometry.class;
        }
        if (point) {
            return multi ? MultiPoint.class : Point.class;
        }
        if (line) {
            return multi ? MultiLineString.class : LineString.class;
        }
        if (poly) {
            return multi ? MultiPolygon.class : Polygon.class;
        }
        if (multi) {
            return GeometryCollection.class;
        }
        return org.locationtech.jts.geom.Geometry.class;
    }

    public Set<Class<? extends org.locationtech.jts.geom.Geometry>> getGeometryTypes(String column) {
        if (column == null) {
            String defaultColumn = this.getPrimaryColumnName().orElse(null);
            if (defaultColumn == null) {
                return Set.of();
            }
            return this.getGeometryTypes(defaultColumn);
        }
        return this.geometryTypes.computeIfAbsent(column, c -> this.computeGeometryTypes((String)c));
    }

    private Set<Class<? extends org.locationtech.jts.geom.Geometry>> computeGeometryTypes(String column) {
        Set types = this.md.values().stream().map(md -> md.getColumn(column)).filter(Optional::isPresent).map(Optional::orElseThrow).map(Geometry::getGeometryTypes).flatMap(Collection::stream).collect(Collectors.toSet());
        return types.stream().map(this::geomType).collect(Collectors.toSet());
    }

    private Class<? extends org.locationtech.jts.geom.Geometry> geomType(String geometryType) {
        if (geometryType == null) {
            return org.locationtech.jts.geom.Geometry.class;
        }
        return GEOMNAME_TO_TYPE.get(geometryType);
    }

    public org.geotools.api.referencing.crs.CoordinateReferenceSystem getCrs() {
        return this.getPrimaryColumn().map(Geometry::getCrs).map(this::parseCrsObject).orElseGet(this::defaultCrs);
    }

    public org.geotools.api.referencing.crs.CoordinateReferenceSystem getCrs(String columnName) {
        return this.getColumn(columnName).map(Geometry::getCrs).map(this::parseCrsObject).orElseGet(this::defaultCrs);
    }

    private org.geotools.api.referencing.crs.CoordinateReferenceSystem parseCrsObject(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        try {
            String projjson = MAPPER.writeValueAsString((Object)crs);
            return ProjJSONHelper.parseCRS(projjson);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Optional<GeoParquetMetadata> sample() {
        return this.md.values().stream().findFirst();
    }

    private org.geotools.api.referencing.crs.CoordinateReferenceSystem defaultCrs() {
        try {
            return CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (FactoryException e) {
            throw new IllegalStateException(e);
        }
    }

    public ReferencedEnvelope getBounds() {
        Stream<Envelope> allFilesBounds = ((Stream)this.md.values().stream().sequential()).map(GeoParquetMetadata::bounds);
        Envelope fullBounds = allFilesBounds.reduce(new Envelope(), (b1, b2) -> {
            b1.expandToInclude(b2);
            return b1;
        });
        org.geotools.api.referencing.crs.CoordinateReferenceSystem crs = this.getCrs();
        return new ReferencedEnvelope(fullBounds, crs);
    }
}

