/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithmND;

import java.util.Iterator;
import java.util.List;
import org.geotools.geometry.iso.aggregate.MultiCurveImpl;
import org.geotools.geometry.iso.complex.CompositeCurveImpl;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.RingImpl;
import org.geotools.geometry.iso.primitive.RingImplUnsafe;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CentroidLine {
    DirectPositionImpl centSum = null;
    private double totalLength = 0.0;

    public CentroidLine(CoordinateReferenceSystem crs) {
        this.centSum = new DirectPositionImpl(crs);
    }

    public void add(Geometry geom) {
        if (geom instanceof CurveImpl) {
            this.addCurve((CurveImpl)geom);
        } else if (geom instanceof RingImpl) {
            this.addCurveIter(((RingImplUnsafe)geom).getGenerators().iterator());
        } else if (geom instanceof MultiCurveImpl) {
            this.addCurveIter(((MultiCurveImpl)geom).getElements().iterator());
        } else if (geom instanceof CompositeCurveImpl) {
            this.addCurveIter(((CompositeCurveImpl)geom).getGenerators().iterator());
        }
    }

    private void addCurveIter(Iterator<OrientableCurve> curveIter) {
        while (curveIter.hasNext()) {
            this.addCurve((CurveImpl)curveIter.next());
        }
    }

    private void addCurve(CurveImpl curve) {
        this.addPointSequence(curve.asDirectPositions());
    }

    public void addPointSequence(List<DirectPosition> pts) {
        DirectPositionImpl dpAct = new DirectPositionImpl(pts.get(0));
        for (int i = 0; i < pts.size() - 1; ++i) {
            DirectPositionImpl directPositionNext = new DirectPositionImpl(pts.get(i + 1));
            double segmentLen = dpAct.distance(directPositionNext);
            this.totalLength += segmentLen;
            DirectPositionImpl tempMid = dpAct.clone();
            tempMid.add(directPositionNext);
            tempMid.divideBy(2.0);
            tempMid.scale(segmentLen);
            this.centSum.add(tempMid);
            dpAct = directPositionNext;
        }
    }

    public DirectPositionImpl getCentroid() {
        this.centSum.divideBy(this.totalLength);
        return this.centSum;
    }
}

