/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithm2D;

import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.geometry.iso.util.algorithm2D.AlgoPoint2D;
import org.geotools.geometry.iso.util.elem2D.Edge2D;

public class AlgoArea {
    public static ArrayList<ArrayList<Line2D>> getBoundariesLines(Area area) {
        ArrayList<ArrayList<Line2D>> result = new ArrayList<ArrayList<Line2D>>();
        PathIterator pi = area.getPathIterator(null);
        double[] coords = new double[6];
        block0: while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            if (type == 0) {
                Point2D.Double p0;
                ArrayList<Line2D.Double> lines = new ArrayList<Line2D.Double>();
                result.add(lines);
                Point2D.Double pStart = p0 = new Point2D.Double(coords[0], coords[1]);
                pi.next();
                while (!pi.isDone()) {
                    Point2D.Double p2;
                    Point2D.Double p1;
                    type = pi.currentSegment(coords);
                    if (type == 4) {
                        if (!AlgoPoint2D.equalsTol(p0, pStart)) {
                            lines.add(new Line2D.Double(p0, pStart));
                        }
                        pi.next();
                        continue block0;
                    }
                    if (type == 1) {
                        p1 = new Point2D.Double(coords[0], coords[1]);
                        lines.add(new Line2D.Double(p0, p1));
                        p0 = p1;
                    } else if (type == 2) {
                        p1 = new Point2D.Double(coords[0], coords[1]);
                        lines.add(new Line2D.Double(p0, p1));
                        p2 = new Point2D.Double(coords[2], coords[3]);
                        lines.add(new Line2D.Double(p1, p2));
                        p0 = p2;
                    } else if (type == 3) {
                        p1 = new Point2D.Double(coords[0], coords[1]);
                        lines.add(new Line2D.Double(p0, p1));
                        p2 = new Point2D.Double(coords[2], coords[3]);
                        lines.add(new Line2D.Double(p1, p2));
                        Point2D.Double p3 = new Point2D.Double(coords[4], coords[5]);
                        lines.add(new Line2D.Double(p2, p3));
                        p0 = p3;
                    } else {
                        throw new IllegalArgumentException("Bad PathIterator");
                    }
                    pi.next();
                }
                continue;
            }
            pi.next();
        }
        return result;
    }

    public ArrayList<ArrayList<Point2D>> getBoundariesPoints(Area area) {
        ArrayList<ArrayList<Point2D>> result = new ArrayList<ArrayList<Point2D>>();
        PathIterator pi = area.getPathIterator(null);
        double[] startCoords = new double[6];
        block0: while (!pi.isDone()) {
            int type = pi.currentSegment(startCoords);
            if (type == 0) {
                ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
                result.add(points);
                points.add(new Point2D.Double(startCoords[0], startCoords[1]));
                pi.next();
                while (!pi.isDone()) {
                    double[] coords = new double[6];
                    type = pi.currentSegment(coords);
                    if (type == 4) {
                        points.add(new Point2D.Double(startCoords[0], startCoords[1]));
                        continue block0;
                    }
                    if (type == 1) {
                        points.add(new Point2D.Double(coords[0], coords[1]));
                    } else if (type == 2) {
                        points.add(new Point2D.Double(coords[0], coords[1]));
                        points.add(new Point2D.Double(coords[2], coords[3]));
                    } else if (type == 3) {
                        points.add(new Point2D.Double(coords[0], coords[1]));
                        points.add(new Point2D.Double(coords[2], coords[3]));
                        points.add(new Point2D.Double(coords[4], coords[5]));
                    } else {
                        throw new IllegalArgumentException("Bad PathIterator");
                    }
                    pi.next();
                }
                continue;
            }
            pi.next();
        }
        return result;
    }

    public static boolean linesOrientation(Collection<Line2D> segments) {
        ArrayList<Point2D> points = new ArrayList<Point2D>(segments.size() + 1);
        Iterator<Line2D> it = segments.iterator();
        while (it.hasNext()) {
            points.add(it.next().getP1());
        }
        return AlgoPoint2D.pointsOrientation(points);
    }

    public static GeneralPath createGeneralPathFromEdges(Collection<Edge2D> edges) {
        ArrayList<Point2D> nodes = new ArrayList<Point2D>(edges.size());
        for (Edge2D edge : edges) {
            nodes.add(edge.getNode1());
        }
        return AlgoArea.createGeneralPathFromNodes(nodes);
    }

    public static GeneralPath createGeneralPathFromNodes(Collection<Point2D> points) {
        if (points == null) {
            return null;
        }
        if (points.isEmpty()) {
            return null;
        }
        Point2D[] pointsArray = new Point2D[points.size()];
        pointsArray = points.toArray(pointsArray);
        int n = pointsArray.length;
        GeneralPath path = new GeneralPath(1, n);
        Point2D p = pointsArray[0];
        path.moveTo((float)p.getX(), (float)p.getY());
        for (int i = 1; i < n - 1; ++i) {
            p = pointsArray[i];
            path.lineTo((float)p.getX(), (float)p.getY());
        }
        if (pointsArray[0].equals(pointsArray[n - 1])) {
            path.closePath();
        } else {
            p = pointsArray[n - 1];
            path.lineTo((float)p.getX(), (float)p.getY());
        }
        return path;
    }
}

