/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.geometry.iso.aggregate.MultiPrimitiveImpl;
import org.geotools.geometry.iso.complex.CompositeCurveImpl;
import org.geotools.geometry.iso.complex.CompositePointImpl;
import org.geotools.geometry.iso.complex.CompositeSurfaceImpl;
import org.geotools.geometry.iso.primitive.CurveBoundaryImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.primitive.RingImpl;
import org.geotools.geometry.iso.primitive.RingImplUnsafe;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.Edge;
import org.geotools.geometry.iso.topograph2D.EdgeIntersection;
import org.geotools.geometry.iso.topograph2D.Label;
import org.geotools.geometry.iso.topograph2D.Node;
import org.geotools.geometry.iso.topograph2D.PlanarGraph;
import org.geotools.geometry.iso.topograph2D.index.EdgeSetIntersector;
import org.geotools.geometry.iso.topograph2D.index.SegmentIntersector;
import org.geotools.geometry.iso.topograph2D.index.SimpleMonotoneChainSweepLineIntersector;
import org.geotools.geometry.iso.topograph2D.util.CoordinateArrays;
import org.geotools.geometry.iso.util.Assert;
import org.geotools.geometry.iso.util.algorithm2D.CGAlgorithms;
import org.geotools.geometry.iso.util.algorithm2D.LineIntersector;
import org.geotools.util.SuppressFBWarnings;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.aggregate.MultiSurface;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Surface;

public class GeometryGraph
extends PlanarGraph {
    private GeometryImpl parentGeom;
    private Map lineEdgeMap = new HashMap();
    private boolean useBoundaryDeterminationRule = true;
    private int argIndex;
    private Collection boundaryNodes;
    private boolean hasTooFewPoints = false;
    private Coordinate invalidPoint = null;

    @SuppressFBWarnings(value={"IM_BAD_CHECK_FOR_ODD"})
    public static boolean isInBoundary(int boundaryCount) {
        if (boundaryCount < 0) {
            throw new IllegalArgumentException("boundaryCount must be non negative, but was " + boundaryCount);
        }
        return boundaryCount % 2 == 1;
    }

    public static int determineBoundary(int boundaryCount) {
        return GeometryGraph.isInBoundary(boundaryCount) ? 1 : 0;
    }

    private EdgeSetIntersector createEdgeSetIntersector() {
        return new SimpleMonotoneChainSweepLineIntersector();
    }

    public GeometryGraph(int argIndex, GeometryImpl parentGeom) {
        this.argIndex = argIndex;
        this.parentGeom = parentGeom;
        if (parentGeom != null) {
            this.add(parentGeom);
        }
    }

    public boolean hasTooFewPoints() {
        return this.hasTooFewPoints;
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    public GeometryImpl getGeometry() {
        return this.parentGeom;
    }

    public Collection getBoundaryNodes() {
        if (this.boundaryNodes == null) {
            this.boundaryNodes = this.nodes.getBoundaryNodes(this.argIndex);
        }
        return this.boundaryNodes;
    }

    public Coordinate[] getBoundaryPoints() {
        Collection coll = this.getBoundaryNodes();
        Coordinate[] pts = new Coordinate[coll.size()];
        int i = 0;
        for (Node node : coll) {
            pts[i++] = (Coordinate)node.getCoordinate().clone();
        }
        return pts;
    }

    public Edge findEdge(CurveImpl line) {
        return (Edge)this.lineEdgeMap.get(line);
    }

    public void computeSplitEdges(List edgelist) {
        for (Edge e : this.edges) {
            e.eiList.addSplitEdges(edgelist);
        }
    }

    private void add(GeometryImpl g) {
        if (g instanceof MultiSurface) {
            this.useBoundaryDeterminationRule = false;
        }
        if (g instanceof PointImpl) {
            this.addPoint((PointImpl)g);
        } else if (g instanceof CurveImpl) {
            this.addCurve((CurveImpl)g);
        } else if (g instanceof CurveBoundaryImpl) {
            this.addCurveBoundary((CurveBoundaryImpl)g);
        } else if (g instanceof RingImplUnsafe) {
            this.addRing((RingImplUnsafe)g);
        } else if (g instanceof RingImpl) {
            this.addRing((RingImpl)g);
        } else if (g instanceof SurfaceImpl) {
            this.addSurface((SurfaceImpl)g);
        } else if (g instanceof SurfaceBoundaryImpl) {
            this.addSurfaceBoundary((SurfaceBoundaryImpl)g);
        } else if (g instanceof CompositePointImpl) {
            this.addCompositePoint((CompositePointImpl)g);
        } else if (g instanceof CompositeCurveImpl) {
            this.addCompositeCurve((CompositeCurveImpl)g);
        } else if (g instanceof CompositeSurfaceImpl) {
            this.addCompositeSurface((CompositeSurfaceImpl)g);
        } else if (g instanceof MultiPrimitiveImpl) {
            this.addMultiPrimitive((MultiPrimitiveImpl)g);
        } else {
            throw new UnsupportedOperationException(g.getClass().getName());
        }
    }

    private void addGeometrySet(Set aSet) {
        Iterator aIter = aSet.iterator();
        while (aIter.hasNext()) {
            this.add((GeometryImpl)aIter.next());
        }
    }

    private void addMultiPrimitive(MultiPrimitiveImpl aMultiPrimitive) {
        this.addGeometrySet(aMultiPrimitive.getElements());
    }

    private void addPoint(PointImpl p) {
        Coordinate coord = new Coordinate(p.getDirectPosition().getCoordinate());
        this.insertPoint(this.argIndex, coord, 0);
    }

    private void addRing(Ring aRing) {
        this.addRing(aRing, 2, 0);
    }

    private void addRing(Ring aRing, int cwLeft, int cwRight) {
        List<DirectPosition> tDPList = ((RingImplUnsafe)aRing).asDirectPositions();
        Coordinate[] coord = CoordinateArrays.toCoordinateArray(tDPList);
        if ((coord = CoordinateArrays.removeRepeatedPoints(coord)).length < 3) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coord[0];
            return;
        }
        int left = cwLeft;
        int right = cwRight;
        if (CGAlgorithms.isCCW(coord)) {
            left = cwRight;
            right = cwLeft;
        }
        Edge e = new Edge(coord, new Label(this.argIndex, 1, left, right));
        this.lineEdgeMap.put(aRing, e);
        this.insertEdge(e);
        this.insertPoint(this.argIndex, coord[0], 1);
    }

    private void addSurface(SurfaceImpl aSurface) {
        this.addSurfaceBoundary(aSurface.getBoundary());
    }

    private void addCurveBoundary(CurveBoundaryImpl aCurveBoundary) {
        this.addPoint(aCurveBoundary.getStartPoint());
        this.addPoint(aCurveBoundary.getEndPoint());
    }

    private void addSurfaceBoundary(SurfaceBoundaryImpl aSurfaceBoundary) {
        this.addRing(aSurfaceBoundary.getExterior(), 2, 0);
        Iterator<Ring> tInteriorIter = aSurfaceBoundary.getInteriors().iterator();
        while (tInteriorIter.hasNext()) {
            this.addRing(tInteriorIter.next(), 0, 2);
        }
    }

    private void addCurve(CurveImpl aCurve) {
        List<DirectPosition> directPositions = aCurve.asDirectPositions();
        Coordinate[] coordinateArray = CoordinateArrays.toCoordinateArray(directPositions);
        Coordinate[] coord = CoordinateArrays.removeRepeatedPoints(coordinateArray);
        if (coord.length < 2) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coord[0];
            return;
        }
        Edge e = new Edge(coord, new Label(this.argIndex, 0));
        this.lineEdgeMap.put(aCurve, e);
        this.insertEdge(e);
        Assert.isTrue(coord.length >= 2, "found LineString with single point");
        this.insertBoundaryPoint(this.argIndex, coord[0]);
        this.insertBoundaryPoint(this.argIndex, coord[coord.length - 1]);
    }

    private void addCompositePoint(CompositePointImpl aCompositePoint) {
        List elements = (List)aCompositePoint.getElements();
        if (elements.size() != 1) {
            throw new IllegalArgumentException("CompositePoint has to hold exactly one Point");
        }
        this.addPoint((PointImpl)elements.get(0));
    }

    private void addCompositeCurve(CompositeCurveImpl aCompositeCurve) {
        Iterator elements = aCompositeCurve.getElements().iterator();
        while (elements.hasNext()) {
            this.addCurve((CurveImpl)elements.next());
        }
    }

    private void addCompositeSurface(CompositeSurfaceImpl aCompositeSurface) {
        Iterator<? extends Primitive> elements = aCompositeSurface.getElements().iterator();
        while (elements.hasNext()) {
            this.addSurface((SurfaceImpl)elements.next());
        }
    }

    public void addEdge(Edge e) {
        this.insertEdge(e);
        Coordinate[] coord = e.getCoordinates();
        this.insertPoint(this.argIndex, coord[0], 1);
        this.insertPoint(this.argIndex, coord[coord.length - 1], 1);
    }

    public void addPoint(Coordinate pt) {
        this.insertPoint(this.argIndex, pt, 0);
    }

    public SegmentIntersector computeSelfNodes(LineIntersector li, boolean computeRingSelfNodes) {
        SegmentIntersector si = new SegmentIntersector(li, true, false);
        EdgeSetIntersector esi = this.createEdgeSetIntersector();
        if (!computeRingSelfNodes && (this.parentGeom instanceof Ring || this.parentGeom instanceof Surface || this.parentGeom instanceof MultiPrimitive)) {
            esi.computeIntersections(this.edges, si, false);
        } else {
            esi.computeIntersections(this.edges, si, true);
        }
        this.addSelfIntersectionNodes(this.argIndex);
        return si;
    }

    public SegmentIntersector computeEdgeIntersections(GeometryGraph g, LineIntersector li, boolean includeProper) {
        SegmentIntersector si = new SegmentIntersector(li, includeProper, true);
        si.setBoundaryNodes(this.getBoundaryNodes(), g.getBoundaryNodes());
        EdgeSetIntersector esi = this.createEdgeSetIntersector();
        esi.computeIntersections(this.edges, g.edges, si);
        return si;
    }

    private void insertPoint(int argIndex, Coordinate coord, int onLocation) {
        Node n = this.nodes.addNode(coord);
        Label lbl = n.getLabel();
        if (lbl == null) {
            n.label = new Label(argIndex, onLocation);
        } else {
            lbl.setLocation(argIndex, onLocation);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    private void insertBoundaryPoint(int argIndex, Coordinate coord) {
        Node n = this.nodes.addNode(coord);
        Label lbl = n.getLabel();
        int boundaryCount = 1;
        int loc = -1;
        if (lbl != null) {
            loc = lbl.getLocation(argIndex, 0);
        }
        if (loc == 1) {
            ++boundaryCount;
        }
        int newLoc = GeometryGraph.determineBoundary(boundaryCount);
        lbl.setLocation(argIndex, newLoc);
    }

    private void addSelfIntersectionNodes(int argIndex) {
        for (Edge e : this.edges) {
            int eLoc = e.getLabel().getLocation(argIndex);
            Iterator eiIt = e.eiList.iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = (EdgeIntersection)eiIt.next();
                this.addSelfIntersectionNode(argIndex, ei.coord, eLoc);
            }
        }
    }

    private void addSelfIntersectionNode(int argIndex, Coordinate coord, int loc) {
        if (this.isBoundaryNode(argIndex, coord)) {
            return;
        }
        if (loc == 1 && this.useBoundaryDeterminationRule) {
            this.insertBoundaryPoint(argIndex, coord);
        } else {
            this.insertPoint(argIndex, coord, loc);
        }
    }
}

