/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.primitive;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.iso.aggregate.MultiSurfaceImpl;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.coordinate.PolygonImpl;
import org.geotools.geometry.iso.coordinate.SurfacePatchImpl;
import org.geotools.geometry.iso.io.GeometryToString;
import org.geotools.geometry.iso.operation.IsSimpleOp;
import org.geotools.geometry.iso.primitive.OrientablePrimitiveImpl;
import org.geotools.geometry.iso.primitive.OrientableSurfaceImpl;
import org.geotools.geometry.iso.primitive.PrimitiveFactoryImpl;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.CompositeSurface;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.geometry.primitive.SurfacePatch;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class SurfaceImpl
extends OrientableSurfaceImpl
implements Surface {
    private static final long serialVersionUID = 2431540523002962079L;
    protected ArrayList<? extends SurfacePatch> patch = null;
    private SurfaceBoundary boundary = null;
    private Envelope envelope;

    public SurfaceImpl(CoordinateReferenceSystem crs, List<? extends SurfacePatch> patch) {
        super(crs, null, null, null);
        this.initializeSurface(patch);
    }

    public SurfaceImpl(SurfaceBoundary boundary) {
        super(boundary.getCoordinateReferenceSystem(), null, null, null);
        this.boundary = boundary;
        this.envelope = boundary.getEnvelope();
        ArrayList<PolygonImpl> newPatchList = new ArrayList<PolygonImpl>();
        newPatchList.add(new PolygonImpl((SurfaceBoundaryImpl)boundary, this));
        this.patch = newPatchList;
    }

    private void initializeSurface(List<? extends SurfacePatch> patch) {
        if (patch == null) {
            throw new IllegalArgumentException("Empty array SurfacePatch.");
        }
        if (patch.isEmpty()) {
            throw new IllegalArgumentException("Empty array SurfacePatch.");
        }
        this.boundary = this.createBoundary(patch);
        ArrayList<SurfacePatch> newPatchList = new ArrayList<SurfacePatch>();
        for (SurfacePatch surfacePatch : patch) {
            if (surfacePatch == null) continue;
            newPatchList.add(surfacePatch);
        }
        this.patch = newPatchList;
        SurfacePatchImpl tFirstPatch = (SurfacePatchImpl)patch.get(0);
        this.envelope = new EnvelopeImpl(tFirstPatch.getEnvelope());
        for (SurfacePatch surfacePatch : patch) {
            ((EnvelopeImpl)this.envelope).expand(((SurfacePatchImpl)surfacePatch).getEnvelope());
        }
    }

    private SurfaceBoundaryImpl createBoundary(List<? extends SurfacePatch> patches) {
        if (patches.isEmpty()) {
            return null;
        }
        SurfacePatch firstPatch = patches.get(0);
        if (patches.size() == 1) {
            return (SurfaceBoundaryImpl)firstPatch.getBoundary();
        }
        SurfaceImpl firstPatchSurface = new SurfaceImpl(firstPatch.getBoundary());
        HashSet<OrientableSurface> surfaceList = new HashSet<OrientableSurface>();
        for (int i = 1; i < patches.size(); ++i) {
            SurfacePatch nextPatch = patches.get(i);
            surfaceList.add((OrientableSurface)new SurfaceImpl(nextPatch.getBoundary()));
        }
        MultiSurfaceImpl ms = new MultiSurfaceImpl(this.getCoordinateReferenceSystem(), (Set<OrientableSurface>)surfaceList);
        TransfiniteSet unionResultSurface = firstPatchSurface.union((TransfiniteSet)ms);
        if (!(unionResultSurface instanceof SurfaceImpl)) {
            throw new IllegalArgumentException("Surface patches are not continuous");
        }
        return ((SurfaceImpl)unionResultSurface).getBoundary();
    }

    @Override
    public SurfaceBoundaryImpl getBoundary() {
        return (SurfaceBoundaryImpl)this.boundary;
    }

    public void setBoundary(SurfaceBoundaryImpl boundary) {
        this.boundary = boundary;
    }

    protected void setPatches(List<? extends SurfacePatch> surfacePatches) {
        this.initializeSurface(surfacePatches);
    }

    public List<? extends SurfacePatch> getPatches() {
        return this.patch;
    }

    @Override
    public Envelope getEnvelope() {
        return this.envelope;
    }

    @Override
    protected OrientablePrimitiveImpl createProxy() {
        return null;
    }

    @Override
    public SurfaceImpl clone() throws CloneNotSupportedException {
        SurfaceBoundary newBoundary = (SurfaceBoundary)this.boundary.clone();
        return new SurfaceImpl(newBoundary);
    }

    public CompositeSurface getComposite() {
        return null;
    }

    public Surface getPrimitive() {
        return null;
    }

    public OrientableSurface[] getProxy() {
        return null;
    }

    public boolean isSimple() {
        IsSimpleOp simpleOp = new IsSimpleOp();
        return simpleOp.isSimple(this);
    }

    public double[] getUpNormal(DirectPosition point) {
        return null;
    }

    public double getPerimeter() {
        return 0.0;
    }

    public double getArea() {
        return 0.0;
    }

    @Override
    public int getDimension(DirectPosition point) {
        return 2;
    }

    public String toString() {
        return GeometryToString.getString(this);
    }

    public List<Ring> getBoundaryRings() {
        ArrayList<Ring> rList = new ArrayList<Ring>();
        rList.add(this.boundary.getExterior());
        Iterator tInteriorRings = this.boundary.getInteriors().iterator();
        while (tInteriorRings.hasNext()) {
            rList.add((Ring)tInteriorRings.next());
        }
        return rList;
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return this.getBoundary().getRepresentativePoint();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.boundary == null ? 0 : this.boundary.hashCode());
        result = 31 * result + (this.envelope == null ? 0 : this.envelope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SurfaceImpl other = (SurfaceImpl)obj;
        return !(this.boundary == null ? other.boundary != null : !this.boundary.equals((TransfiniteSet)other.boundary));
    }

    @Override
    public Geometry transform(CoordinateReferenceSystem newCRS, MathTransform transform) throws TransformException {
        PrimitiveFactoryImpl primitiveFactory = new PrimitiveFactoryImpl(newCRS, this.getPositionFactory());
        List<Ring> currentRings = this.getBoundaryRings();
        Iterator<Ring> iter = currentRings.iterator();
        Ring newExterior = null;
        ArrayList<Ring> newInteriors = new ArrayList<Ring>();
        while (iter.hasNext()) {
            Ring thisRing = iter.next();
            if (newExterior == null) {
                newExterior = (Ring)thisRing.transform(newCRS, transform);
                continue;
            }
            newInteriors.add((Ring)thisRing.transform(newCRS, transform));
        }
        SurfaceBoundaryImpl surfaceBoundary = (SurfaceBoundaryImpl)primitiveFactory.createSurfaceBoundary(newExterior, newInteriors);
        SurfaceImpl newSurface = (SurfaceImpl)primitiveFactory.createSurface(surfaceBoundary);
        return newSurface;
    }
}

