/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.primitive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.geometry.GeometryFactoryFinder;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.LineSegmentImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.geometry.iso.coordinate.PositionImpl;
import org.geotools.geometry.iso.coordinate.SurfacePatchImpl;
import org.geotools.geometry.iso.primitive.CurveBoundaryImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.primitive.PrimitiveImpl;
import org.geotools.geometry.iso.primitive.RingImpl;
import org.geotools.geometry.iso.primitive.RingImplUnsafe;
import org.geotools.geometry.iso.primitive.SolidImpl;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.PrimitiveFactory;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SolidBoundary;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.geometry.primitive.SurfacePatch;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class PrimitiveFactoryImpl
implements Serializable,
Factory,
PrimitiveFactory {
    private static final long serialVersionUID = 1L;
    private CoordinateReferenceSystem crs;
    private PositionFactory positionFactory;
    private Boolean geomValidate;
    private Map hintsWeCareAbout = new HashMap();

    public PrimitiveFactoryImpl() {
        this(null);
    }

    public PrimitiveFactoryImpl(Hints hints) {
        if (hints == null) {
            this.crs = DefaultGeographicCRS.WGS84;
            hints = GeoTools.getDefaultHints();
            hints.put((Object)Hints.CRS, (Object)this.crs);
            this.geomValidate = true;
            hints.put((Object)Hints.GEOMETRY_VALIDATE, (Object)this.geomValidate);
        } else {
            this.crs = (CoordinateReferenceSystem)hints.get((Object)Hints.CRS);
            if (this.crs == null) {
                throw new NullPointerException("A CRS Hint is required in order to use PrimitiveFactoryImpl");
            }
            this.geomValidate = (Boolean)hints.get((Object)Hints.GEOMETRY_VALIDATE);
            if (this.geomValidate == null) {
                this.geomValidate = true;
            }
        }
        this.positionFactory = GeometryFactoryFinder.getPositionFactory((Hints)hints);
        this.hintsWeCareAbout.put(Hints.CRS, this.crs);
        this.hintsWeCareAbout.put(Hints.POSITION_FACTORY, this.positionFactory);
        this.hintsWeCareAbout.put(Hints.GEOMETRY_VALIDATE, this.geomValidate);
    }

    public PrimitiveFactoryImpl(CoordinateReferenceSystem crs, PositionFactory positionFactory) {
        this.crs = crs;
        if (crs == null) {
            throw new NullPointerException("A non null crs is required in order to use PrimitiveFactoryImpl");
        }
        if (positionFactory == null) {
            Hints hints = GeoTools.getDefaultHints();
            hints.put((Object)Hints.CRS, (Object)crs);
            this.positionFactory = GeometryFactoryFinder.getPositionFactory((Hints)hints);
        } else {
            this.positionFactory = positionFactory;
        }
        this.geomValidate = true;
        this.hintsWeCareAbout.put(Hints.CRS, crs);
        this.hintsWeCareAbout.put(Hints.POSITION_FACTORY, positionFactory);
        this.hintsWeCareAbout.put(Hints.GEOMETRY_VALIDATE, this.geomValidate);
    }

    public Map getImplementationHints() {
        return Collections.unmodifiableMap(this.hintsWeCareAbout);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public PositionFactory getPositionFactory() {
        return this.positionFactory;
    }

    public int getDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    public PointImpl createPoint(double[] coord) {
        if (coord == null) {
            throw new NullPointerException();
        }
        if (coord.length != this.getDimension()) {
            throw new MismatchedDimensionException();
        }
        return new PointImpl(this.positionFactory.createDirectPosition(coord));
    }

    public PointImpl createPoint(DirectPositionImpl dp) {
        if (dp == null) {
            throw new NullPointerException();
        }
        if (dp.getDimension() != this.getDimension()) {
            throw new MismatchedDimensionException();
        }
        return new PointImpl(dp.clone());
    }

    public PointImpl createPoint(Position position) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        if (position == null) {
            throw new IllegalArgumentException("Parameter position is null.");
        }
        if (position.getDirectPosition().getDimension() != this.getDimension()) {
            throw new MismatchedDimensionException();
        }
        DirectPosition copy = this.positionFactory.createDirectPosition(position.getDirectPosition().getCoordinate());
        return new PointImpl(copy);
    }

    public CurveBoundaryImpl createCurveBoundary(DirectPosition dp0, DirectPosition dp1) {
        if (dp0 == null || dp1 == null) {
            throw new NullPointerException("One or both of the parameters is NULL");
        }
        return new CurveBoundaryImpl(this.getCoordinateReferenceSystem(), this.createPoint((Position)dp0), this.createPoint((Position)dp1));
    }

    public CurveBoundaryImpl createCurveBoundary(Point p0, Point p1) {
        if (p0 == null || p1 == null) {
            throw new NullPointerException("One or both of the parameters is NULL");
        }
        return new CurveBoundaryImpl(this.getCoordinateReferenceSystem(), p0, p1);
    }

    public CurveImpl createCurve(List<CurveSegment> segments) {
        if (segments == null) {
            throw new NullPointerException();
        }
        return new CurveImpl(this.getCoordinateReferenceSystem(), segments);
    }

    public Ring createRing(List<OrientableCurve> orientableCurves) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        for (OrientableCurve orientableCurve : orientableCurves) {
            if (this.getDimension() != orientableCurve.getCoordinateDimension()) {
                throw new MismatchedDimensionException();
            }
            if (CRS.equalsIgnoreMetadata((Object)this.getCoordinateReferenceSystem(), (Object)orientableCurve.getCoordinateReferenceSystem())) continue;
            throw new MismatchedReferenceSystemException();
        }
        if (this.geomValidate.booleanValue()) {
            return new RingImpl(orientableCurves);
        }
        return new RingImplUnsafe(orientableCurves);
    }

    public SurfaceBoundaryImpl createSurfaceBoundary(Ring exterior, List<Ring> interiors) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        if (interiors == null && exterior == null) {
            throw new NullPointerException();
        }
        CoordinateReferenceSystem thisCRS = this.getCoordinateReferenceSystem();
        if (exterior != null) {
            if (this.getDimension() != exterior.getCoordinateDimension()) {
                throw new MismatchedDimensionException();
            }
            CoordinateReferenceSystem exteriorCRS = exterior.getCoordinateReferenceSystem();
            if (!CRS.equalsIgnoreMetadata((Object)thisCRS, (Object)exteriorCRS)) {
                throw new MismatchedReferenceSystemException();
            }
        }
        if (interiors != null) {
            for (Ring ring : interiors) {
                if (ring == null) continue;
                if (this.getDimension() != ring.getCoordinateDimension()) {
                    throw new MismatchedDimensionException();
                }
                if (CRS.equalsIgnoreMetadata((Object)thisCRS, (Object)ring.getCoordinateReferenceSystem())) continue;
                throw new MismatchedReferenceSystemException();
            }
        }
        return new SurfaceBoundaryImpl(this.getCoordinateReferenceSystem(), exterior, interiors);
    }

    public SurfaceImpl createSurface(List<SurfacePatch> surfacePatches) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        SurfaceImpl rSurface = new SurfaceImpl(this.getCoordinateReferenceSystem(), surfacePatches);
        for (int i = 0; i < surfacePatches.size(); ++i) {
            SurfacePatchImpl actPatch = (SurfacePatchImpl)surfacePatches.get(i);
            actPatch.setSurface(rSurface);
        }
        return rSurface;
    }

    public SurfaceImpl createSurface(SurfaceBoundary boundary) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return new SurfaceImpl(boundary);
    }

    public SolidImpl createSolid(SolidBoundary boundary) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return new SolidImpl(boundary);
    }

    public PrimitiveImpl createPrimitive(Envelope bounds) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        LineSegment segment = this.processBoundsToSegment(bounds);
        return this.processSegmentToPrimitive(bounds, segment, 1);
    }

    private PrimitiveImpl processSegmentToPrimitive(Envelope bounds, LineSegment segment, int dimension) {
        CoordinateSystemAxis axis = this.crs.getCoordinateSystem().getAxis(dimension);
        if (axis.getDirection() == AxisDirection.OTHER) {
            return this.processSegmentToPrimitive(bounds, segment, dimension + 1);
        }
        Ring ring = this.processBoundsToRing(bounds, segment, dimension);
        return this.processRingToPrimitive(bounds, ring, dimension + 1);
    }

    private PrimitiveImpl processRingToPrimitive(Envelope bounds, Ring ring, int dimension) {
        int D = this.crs.getCoordinateSystem().getDimension();
        if (dimension == D) {
            SurfaceBoundaryImpl boundary = new SurfaceBoundaryImpl(this.crs, ring, Collections.EMPTY_LIST);
            return new SurfaceImpl(boundary);
        }
        CoordinateSystemAxis axis = this.crs.getCoordinateSystem().getAxis(dimension);
        if (axis.getDirection() == AxisDirection.OTHER) {
            return this.processRingToPrimitive(bounds, ring, dimension + 1);
        }
        return this.processRingToVolumne(bounds, ring, dimension + 1);
    }

    private PrimitiveImpl processRingToVolumne(Envelope bounds, Ring ring, int i) {
        throw new UnsupportedOperationException("Not yet 3D");
    }

    public LineSegment processBoundsToSegment(Envelope bounds) {
        boolean D = false;
        CoordinateReferenceSystem crs = bounds.getCoordinateReferenceSystem();
        CoordinateSystemAxis axis = crs.getCoordinateSystem().getAxis(0);
        DirectPosition positionA = this.positionFactory.createDirectPosition(null);
        DirectPosition positionB = this.positionFactory.createDirectPosition(null);
        if (axis.getDirection() != AxisDirection.OTHER) {
            positionA.setOrdinate(0, bounds.getMinimum(0));
            positionB.setOrdinate(0, bounds.getMaximum(0));
        }
        PointArrayImpl array = new PointArrayImpl(crs);
        array.add(positionA);
        array.add(positionB);
        return new LineSegmentImpl(array, 0.0);
    }

    public Ring processBoundsToRing(Envelope bounds, LineSegment segment, int D) {
        DirectPosition one = this.positionFactory.createDirectPosition(segment.getStartPoint().getCoordinate());
        one.setOrdinate(D, bounds.getMinimum(D));
        DirectPosition two = this.positionFactory.createDirectPosition(segment.getEndPoint().getCoordinate());
        two.setOrdinate(D, bounds.getMinimum(D));
        DirectPosition three = this.positionFactory.createDirectPosition(two.getCoordinate());
        three.setOrdinate(D, bounds.getMaximum(D));
        DirectPosition four = this.positionFactory.createDirectPosition(one.getCoordinate());
        four.setOrdinate(D, bounds.getMaximum(D));
        LineSegmentImpl edge1 = new LineSegmentImpl(one, two, 0.0);
        LineSegmentImpl edge2 = new LineSegmentImpl(two, three, 0.0);
        LineSegmentImpl edge3 = new LineSegmentImpl(three, four, 0.0);
        LineSegmentImpl edge4 = new LineSegmentImpl(four, one, 0.0);
        ArrayList<OrientableCurve> edges = new ArrayList<OrientableCurve>();
        edges.add(new CurveImpl(edge1));
        edges.add(new CurveImpl(edge2));
        edges.add(new CurveImpl(edge3));
        edges.add(new CurveImpl(edge4));
        return this.createRing(edges);
    }

    public Ring createRingByDirectPositions(List<DirectPosition> directPositions) {
        Curve curve = this.createCurveByDirectPositions(directPositions);
        ArrayList<OrientableCurve> orientableCurves = new ArrayList<OrientableCurve>();
        orientableCurves.add((OrientableCurve)curve);
        return this.createRing(orientableCurves);
    }

    public Ring createRingByPositions(List<Position> aPositions) {
        CurveImpl curve = this.createCurveByPositions(aPositions);
        ArrayList<OrientableCurve> orientableCurves = new ArrayList<OrientableCurve>();
        orientableCurves.add(curve);
        return this.createRing(orientableCurves);
    }

    public Curve createCurveByDirectPositions(List<DirectPosition> aDirectPositions) {
        List<Position> positionList = this.createPositions(aDirectPositions);
        LineStringImpl lineString = new LineStringImpl(new PointArrayImpl(positionList), 0.0);
        ArrayList<LineStringImpl> segments = new ArrayList<LineStringImpl>();
        segments.add(lineString);
        return this.createCurve(segments);
    }

    public List<Position> createPositions(List<DirectPosition> aDirectPositions) {
        LinkedList<Position> rPositions = new LinkedList<Position>();
        for (int i = 0; i < aDirectPositions.size(); ++i) {
            rPositions.add(new PositionImpl(aDirectPositions.get(i)));
        }
        return rPositions;
    }

    public CurveImpl createCurveByPositions(List<Position> aPositions) {
        LineStringImpl lineString = new LineStringImpl(new PointArrayImpl(aPositions), 0.0);
        ArrayList<LineStringImpl> segments = new ArrayList<LineStringImpl>();
        segments.add(lineString);
        return this.createCurve(segments);
    }

    public SurfaceImpl createSurfaceByDirectPositions(List<DirectPosition> positions) {
        Ring extRing = this.createRingByDirectPositions(positions);
        ArrayList intRings = new ArrayList();
        SurfaceBoundary sfb = this.createSurfaceBoundary(extRing, (List)intRings);
        return this.createSurface(sfb);
    }
}

