/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.primitive;

import org.geotools.geometry.iso.PositionFactoryImpl;
import org.geotools.geometry.iso.complex.CompositePointImpl;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.io.GeometryToString;
import org.geotools.geometry.iso.primitive.PrimitiveFactoryImpl;
import org.geotools.geometry.iso.primitive.PrimitiveImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Bearing;
import org.opengis.geometry.primitive.OrientablePrimitive;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.PrimitiveBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class PointImpl
extends PrimitiveImpl
implements Point {
    private static final long serialVersionUID = -1750949790172649244L;
    private DirectPositionImpl position = null;

    public PointImpl(DirectPosition position) {
        super(position.getCoordinateReferenceSystem());
        this.position = new DirectPositionImpl(position);
    }

    public PointImpl(CoordinateReferenceSystem crs, DirectPositionImpl dp) {
        super(crs, null, null, null);
        this.position = dp;
    }

    @Override
    public PointImpl clone() throws CloneNotSupportedException {
        return new PointImpl(this.position);
    }

    public DirectPositionImpl getDirectPosition() {
        return this.position;
    }

    public void setDirectPosition(DirectPosition p) {
        this.position = new DirectPositionImpl(p);
    }

    public String toString() {
        return GeometryToString.getString(this);
    }

    public Bearing getBearing(Position toPoint) {
        return null;
    }

    @Override
    public int getDimension(DirectPosition point) {
        return 0;
    }

    @Override
    public Envelope getEnvelope() {
        return new EnvelopeImpl(this.position);
    }

    @Override
    public PrimitiveBoundary getBoundary() {
        return null;
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return this.position;
    }

    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isCycle() {
        return true;
    }

    @Override
    public DirectPosition getCentroid() {
        return this.position;
    }

    @Override
    public OrientablePrimitive[] getProxy() {
        return null;
    }

    @Override
    public boolean equals(TransfiniteSet pointSet) {
        if (!(pointSet instanceof PointImpl)) {
            return super.equals(pointSet);
        }
        return this.getDirectPosition().equals(((PointImpl)pointSet).getDirectPosition());
    }

    @Override
    public Complex getClosure() {
        return new CompositePointImpl(this);
    }

    @Override
    public Geometry transform(CoordinateReferenceSystem newCRS, MathTransform transform) throws MismatchedDimensionException, TransformException {
        PositionFactoryImpl newPositionFactory = new PositionFactoryImpl(newCRS, this.getPositionFactory().getPrecision());
        PrimitiveFactoryImpl newPrimitiveFactory = new PrimitiveFactoryImpl(newCRS, newPositionFactory);
        DirectPositionImpl dp1 = new DirectPositionImpl(newCRS);
        dp1 = transform.transform((DirectPosition)this.getDirectPosition(), (DirectPosition)dp1);
        return newPrimitiveFactory.createPoint((Position)dp1);
    }
}

