/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.operation.overlay;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.geotools.geometry.iso.UnsupportedDimensionException;
import org.geotools.geometry.iso.aggregate.AggregateFactoryImpl;
import org.geotools.geometry.iso.operation.GeometryGraphOperation;
import org.geotools.geometry.iso.operation.overlay.LineBuilder;
import org.geotools.geometry.iso.operation.overlay.OverlayNodeFactory;
import org.geotools.geometry.iso.operation.overlay.PointBuilder;
import org.geotools.geometry.iso.operation.overlay.PolygonBuilder;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.Depth;
import org.geotools.geometry.iso.topograph2D.DirectedEdge;
import org.geotools.geometry.iso.topograph2D.DirectedEdgeStar;
import org.geotools.geometry.iso.topograph2D.Edge;
import org.geotools.geometry.iso.topograph2D.EdgeList;
import org.geotools.geometry.iso.topograph2D.Label;
import org.geotools.geometry.iso.topograph2D.Node;
import org.geotools.geometry.iso.topograph2D.PlanarGraph;
import org.geotools.geometry.iso.util.Assert;
import org.geotools.geometry.iso.util.algorithm2D.PointLocator;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OverlayOp
extends GeometryGraphOperation {
    public static final int INTERSECTION = 1;
    public static final int UNION = 2;
    public static final int DIFFERENCE = 3;
    public static final int SYMDIFFERENCE = 4;
    private final PointLocator ptLocator = new PointLocator();
    private CoordinateReferenceSystem crs;
    private GeometryImpl resultGeom;
    private PlanarGraph graph;
    private EdgeList edgeList = new EdgeList();
    private List<OrientableSurface> resultPolyList = new ArrayList<OrientableSurface>();
    private List<OrientableCurve> resultLineList = new ArrayList<OrientableCurve>();
    private List<Point> resultPointList = new ArrayList<Point>();

    public static GeometryImpl overlayOp(GeometryImpl geom0, GeometryImpl geom1, int opCode) throws UnsupportedDimensionException {
        OverlayOp gov = new OverlayOp(geom0, geom1);
        GeometryImpl geomOv = gov.getResultGeometry(opCode);
        return geomOv;
    }

    public static boolean isResultOfOp(Label label, int opCode) {
        int loc0 = label.getLocation(0);
        int loc1 = label.getLocation(1);
        return OverlayOp.isResultOfOp(loc0, loc1, opCode);
    }

    public static boolean isResultOfOp(int loc0, int loc1, int opCode) {
        if (loc0 == 1) {
            loc0 = 0;
        }
        if (loc1 == 1) {
            loc1 = 0;
        }
        switch (opCode) {
            case 1: {
                return loc0 == 0 && loc1 == 0;
            }
            case 2: {
                return loc0 == 0 || loc1 == 0;
            }
            case 3: {
                return loc0 == 0 && loc1 != 0;
            }
            case 4: {
                return loc0 == 0 && loc1 != 0 || loc0 != 0 && loc1 == 0;
            }
        }
        return false;
    }

    public OverlayOp(GeometryImpl g0, GeometryImpl g1) throws UnsupportedDimensionException {
        super(g0, g1);
        this.graph = new PlanarGraph(new OverlayNodeFactory());
        this.crs = g0.getCoordinateReferenceSystem();
    }

    public GeometryImpl getResultGeometry(int funcCode) {
        this.computeOverlay(funcCode);
        return this.resultGeom;
    }

    public PlanarGraph getGraph() {
        return this.graph;
    }

    private void computeOverlay(int opCode) {
        this.copyPoints(0);
        this.copyPoints(1);
        this.arg[0].computeSelfNodes(this.li, false);
        this.arg[1].computeSelfNodes(this.li, false);
        this.arg[0].computeEdgeIntersections(this.arg[1], this.li, true);
        ArrayList baseSplitEdges = new ArrayList();
        this.arg[0].computeSplitEdges(baseSplitEdges);
        this.arg[1].computeSplitEdges(baseSplitEdges);
        this.insertUniqueEdges(baseSplitEdges);
        this.computeLabelsFromDepths();
        this.replaceCollapsedEdges();
        this.graph.addEdges(this.edgeList.getEdges());
        this.computeLabelling();
        this.labelIncompleteNodes();
        this.findResultAreaEdges(opCode);
        this.cancelDuplicateResultEdges();
        PolygonBuilder polyBuilder = new PolygonBuilder(this.crs, this.cga);
        polyBuilder.add(this.graph);
        this.resultPolyList = polyBuilder.getPolygons();
        LineBuilder lineBuilder = new LineBuilder(this, this.crs, this.ptLocator);
        this.resultLineList = lineBuilder.build(opCode);
        PointBuilder pointBuilder = new PointBuilder(this, this.crs, this.ptLocator);
        this.resultPointList = pointBuilder.build(opCode);
        this.resultGeom = this.computeGeometry(this.resultPointList, this.resultLineList, this.resultPolyList);
    }

    private void insertUniqueEdges(List edges) {
        for (Edge e : edges) {
            this.insertUniqueEdge(e);
        }
    }

    protected void insertUniqueEdge(Edge e) {
        Edge existingEdge = this.edgeList.findEqualEdge(e);
        if (existingEdge != null) {
            Depth depth;
            Label existingLabel = existingEdge.getLabel();
            Label labelToMerge = e.getLabel();
            if (!existingEdge.isPointwiseEqual(e)) {
                labelToMerge = new Label(e.getLabel());
                labelToMerge.flip();
            }
            if ((depth = existingEdge.getDepth()).isNull()) {
                depth.add(existingLabel);
            }
            depth.add(labelToMerge);
            existingLabel.merge(labelToMerge);
        } else {
            this.edgeList.add(e);
        }
    }

    private void computeLabelsFromDepths() {
        Iterator it = this.edgeList.iterator();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            Label lbl = e.getLabel();
            Depth depth = e.getDepth();
            if (depth.isNull()) continue;
            depth.normalize();
            for (int i = 0; i < 2; ++i) {
                if (lbl.isNull(i) || !lbl.isArea() || depth.isNull(i)) continue;
                if (depth.getDelta(i) == 0) {
                    lbl.toLine(i);
                    continue;
                }
                Assert.isTrue(!depth.isNull(i, 1), "depth of LEFT side has not been initialized");
                lbl.setLocation(i, 1, depth.getLocation(i, 1));
                Assert.isTrue(!depth.isNull(i, 2), "depth of RIGHT side has not been initialized");
                lbl.setLocation(i, 2, depth.getLocation(i, 2));
            }
        }
    }

    private void replaceCollapsedEdges() {
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        Iterator it = this.edgeList.iterator();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            if (!e.isCollapsed()) continue;
            it.remove();
            newEdges.add(e.getCollapsedEdge());
        }
        this.edgeList.addAll(newEdges);
    }

    private void copyPoints(int argIndex) {
        Iterator i = this.arg[argIndex].getNodeIterator();
        while (i.hasNext()) {
            Node graphNode = (Node)i.next();
            Node newNode = this.graph.addNode(graphNode.getCoordinate());
            newNode.setLabel(argIndex, graphNode.getLabel().getLocation(argIndex));
        }
    }

    private void computeLabelling() {
        for (Node node : this.graph.getNodes()) {
            node.getEdges().computeLabelling(this.arg);
        }
        this.mergeSymLabels();
        this.updateNodeLabelling();
    }

    private void mergeSymLabels() {
        for (Node node : this.graph.getNodes()) {
            ((DirectedEdgeStar)node.getEdges()).mergeSymLabels();
        }
    }

    private void updateNodeLabelling() {
        for (Node node : this.graph.getNodes()) {
            Label lbl = ((DirectedEdgeStar)node.getEdges()).getLabel();
            node.getLabel().merge(lbl);
        }
    }

    private void labelIncompleteNodes() {
        for (Node n : this.graph.getNodes()) {
            Label label = n.getLabel();
            if (n.isIsolated()) {
                if (label.isNull(0)) {
                    this.labelIncompleteNode(n, 0);
                } else {
                    this.labelIncompleteNode(n, 1);
                }
            }
            ((DirectedEdgeStar)n.getEdges()).updateLabelling(label);
        }
    }

    private void labelIncompleteNode(Node n, int targetIndex) {
        int loc = this.ptLocator.locate(n.getCoordinate(), this.arg[targetIndex].getGeometry());
        n.getLabel().setLocation(targetIndex, loc);
    }

    private void findResultAreaEdges(int opCode) {
        for (DirectedEdge de : this.graph.getEdgeEnds()) {
            Label label = de.getLabel();
            if (!label.isArea() || de.isInteriorAreaEdge() || !OverlayOp.isResultOfOp(label.getLocation(0, 2), label.getLocation(1, 2), opCode)) continue;
            de.setInResult(true);
        }
    }

    private void cancelDuplicateResultEdges() {
        for (DirectedEdge de : this.graph.getEdgeEnds()) {
            DirectedEdge sym = de.getSym();
            if (!de.isInResult() || !sym.isInResult()) continue;
            de.setInResult(false);
            sym.setInResult(false);
        }
    }

    public boolean isCoveredByLA(Coordinate coord) {
        if (this.isCovered(coord, this.resultLineList)) {
            return true;
        }
        return this.isCovered(coord, this.resultPolyList);
    }

    public boolean isCoveredByA(Coordinate coord) {
        return this.isCovered(coord, this.resultPolyList);
    }

    private boolean isCovered(Coordinate coord, List geomList) {
        for (GeometryImpl geom : geomList) {
            int loc = this.ptLocator.locate(coord, geom);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }

    private GeometryImpl computeGeometry(List<Point> resultPointList, List<OrientableCurve> resultLineList, List<OrientableSurface> resultPolyList) {
        return this.createGeometry(resultPolyList, resultLineList, resultPointList);
    }

    public GeometryImpl createGeometry(List<OrientableSurface> aSurfaces, List<OrientableCurve> aCurves, List<Point> aPoints) {
        int nS = aSurfaces.size();
        int nC = aCurves.size();
        int nP = aPoints.size();
        AggregateFactoryImpl aggregateFactory = new AggregateFactoryImpl(this.crs);
        if (nS + nC + nP == 0) {
            return null;
        }
        if (nS == 0) {
            if (nC == 0) {
                if (nP == 1) {
                    return (GeometryImpl)aPoints.get(0);
                }
                return (GeometryImpl)aggregateFactory.createMultiPoint(new HashSet<Point>(aPoints));
            }
            if (nP == 0) {
                if (nC == 1) {
                    return (GeometryImpl)aCurves.get(0);
                }
                return (GeometryImpl)aggregateFactory.createMultiCurve(new HashSet<OrientableCurve>(aCurves));
            }
        } else if (nC == 0 && nP == 0) {
            if (nS == 1) {
                return (GeometryImpl)aSurfaces.get(0);
            }
            return (GeometryImpl)aggregateFactory.createMultiSurface(new HashSet<OrientableSurface>(aSurfaces));
        }
        HashSet<Primitive> tPrimitives = new HashSet<Primitive>();
        tPrimitives.addAll(aSurfaces);
        tPrimitives.addAll(aCurves);
        tPrimitives.addAll(aPoints);
        return (GeometryImpl)aggregateFactory.createMultiPrimitive(tPrimitives);
    }
}

