/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.coordinate.LineSegmentImpl;
import org.geotools.geometry.iso.coordinate.PositionImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.util.DoubleOperation;
import org.geotools.geometry.iso.util.algorithmND.AlgoPointND;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PointArrayImpl
extends ArrayList<Position>
implements PointArray {
    CoordinateReferenceSystem crs;

    public PointArrayImpl(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public PointArrayImpl(DirectPosition p1, DirectPosition p2) {
        this.crs = p1.getCoordinateReferenceSystem();
        this.add(p1);
        this.add(p2);
    }

    public PointArrayImpl(PointArray aPointArray) {
        if (aPointArray.isEmpty()) {
            throw new IllegalArgumentException("Parameter PointArray is empty. Cannot create empty PointArray as we need the CRS");
        }
        for (int i = 0; i < aPointArray.size(); ++i) {
            PositionImpl copy = new PositionImpl(aPointArray.getDirectPosition(i, null));
            this.add(copy);
        }
        this.crs = this.getDirectPosition(0).getDirectPosition().getCoordinateReferenceSystem();
    }

    public PointArrayImpl(List<Position> positions) {
        super(positions);
        if (positions.size() == 0) {
            throw new IllegalArgumentException("Parameter positions is empty. Cannot create empty PointArray as we need the CRS");
        }
        this.crs = this.getDirectPosition(0).getDirectPosition().getCoordinateReferenceSystem();
    }

    public List<Position> getPointArray() {
        return this;
    }

    public double[] getCoordinate(int index) {
        Position pos = this.getDirectPosition(index);
        return pos.getDirectPosition().getCoordinate();
    }

    public Position getDirectPosition(int index) {
        return (Position)this.get(index);
    }

    @Override
    public Position getFirst() {
        return (Position)this.get(0);
    }

    @Override
    public Position getLast() {
        return (Position)this.get(this.size() - 1);
    }

    public int length() {
        return this.size();
    }

    public double getDistanceSum() {
        double dist = 0.0;
        double[] c0 = this.getCoordinate(0);
        for (int i = 1; i < this.length(); ++i) {
            double[] c1 = this.getCoordinate(i);
            dist = DoubleOperation.add(dist, AlgoPointND.getDistance(c0, c1));
            c0 = c1;
        }
        return dist;
    }

    public EnvelopeImpl getEnvelope() {
        Position position = this.getDirectPosition(0);
        EnvelopeImpl env = new EnvelopeImpl(position);
        int n = this.length();
        for (int i = 1; i < n; ++i) {
            double[] c1 = this.getCoordinate(i);
            env.expand(c1);
        }
        return env;
    }

    public boolean removePosition(Position p) {
        return this.remove(p);
    }

    @Override
    public String toString() {
        String rString = "";
        for (int i = 0; i < this.size(); ++i) {
            rString = rString + this.get(i) + ", ";
        }
        return rString;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public DirectPosition getPosition(int col, DirectPosition dest) throws IndexOutOfBoundsException {
        Position pos = (Position)this.get(col);
        double[] coords = pos.getDirectPosition().getCoordinate();
        if (dest != null) {
            if (dest instanceof DirectPositionImpl) {
                DirectPositionImpl fast = (DirectPositionImpl)dest;
                fast.setCoordinate(coords);
            } else {
                for (int i = 0; i < coords.length; ++i) {
                    dest.setOrdinate(i, coords[i]);
                }
            }
        } else {
            dest = pos.getDirectPosition();
        }
        return dest;
    }

    public void setPosition(int index, DirectPosition position) throws IndexOutOfBoundsException, UnsupportedOperationException {
        Position pos = (Position)this.get(index);
        DirectPosition inPlace = pos.getDirectPosition();
        double[] coord = position.getCoordinate();
        for (int i = 0; i < coord.length; ++i) {
            inPlace.setOrdinate(i, coord[i]);
        }
    }

    @Override
    public void set(int index, double[] coord) {
        Position pos = (Position)this.get(index);
        DirectPosition position = pos.getDirectPosition();
        for (int i = 0; i < coord.length; ++i) {
            position.setOrdinate(i, coord[i]);
        }
    }

    public List positions() {
        return this;
    }

    public void merge(double minSpacing) {
        minSpacing *= minSpacing;
        double[] c0 = this.getCoordinate(0);
        int n = this.length();
        for (int i = 1; i < n; ++i) {
            double[] c1 = this.getCoordinate(i);
            while (AlgoPointND.getDistanceSquare(c0, c1) < minSpacing) {
                this.remove(i);
                --n;
                c1 = this.getCoordinate(i);
            }
            c0 = c1;
        }
    }

    public void split(double maxSpacing) {
        double[] c0 = this.getCoordinate(0);
        int n = this.length();
        for (int i = 1; i < n; ++i) {
            double[] c1 = this.getCoordinate(i);
            double[][] newCoords = AlgoPointND.split(c0, c1, maxSpacing);
            if (newCoords != null) {
                int j = 0;
                while (i < newCoords.length) {
                    this.set(i, newCoords[j]);
                    ++j;
                    ++i;
                    ++n;
                }
            }
            c0 = c1;
        }
    }

    public List<? extends LineSegment> getLineSegments(CurveImpl parentCurve) {
        return new LineSegmentsSequence(this, parentCurve);
    }

    public int getDimension() {
        return 0;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.crs == null ? 0 : this.crs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = ((List)obj).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Position o1 = (Position)e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        if (e1.hasNext() && !e2.hasNext()) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointArrayImpl other = (PointArrayImpl)obj;
        return !(this.crs == null ? other.crs != null : !this.crs.equals(other.crs));
    }

    public DirectPosition getDirectPosition(int index, DirectPosition dest) throws IndexOutOfBoundsException {
        if (dest == null) {
            dest = new DirectPositionImpl((Position)this.get(index));
        } else {
            assert (dest.getCoordinateReferenceSystem().equals(this.crs));
            DirectPositionImpl dp = new DirectPositionImpl((Position)this.get(index));
            for (int i = 0; i < dp.getCoordinate().length; ++i) {
                dest.setOrdinate(i, dp.getOrdinate(i));
            }
        }
        return dest;
    }

    public void setDirectPosition(int index, DirectPosition position) throws IndexOutOfBoundsException, UnsupportedOperationException {
        this.setPosition(index, position);
    }

    public class LineSegmentsSequence
    extends AbstractList<LineSegmentImpl> {
        private PointArrayImpl pointArray;
        private int index;
        private double length;
        private CurveImpl parentCurve = null;

        public LineSegmentsSequence(PointArrayImpl pointArray, CurveImpl aParentCurve) {
            this.pointArray = pointArray;
            this.index = 0;
            this.length = 0.0;
            this.parentCurve = aParentCurve;
        }

        @Override
        public LineSegmentImpl get(int arg0) {
            double[] p0 = this.getStartCoordinate(arg0);
            double[] p1 = this.getEndCoordinate(arg0);
            double startParam = 0.0;
            for (int i = 1; i <= arg0; ++i) {
                startParam = DoubleOperation.add(startParam, AlgoPointND.getDistance(this.getStartCoordinate(i - 1), this.getEndCoordinate(i - 1)));
            }
            LineSegmentImpl rSeg = new LineSegmentImpl(this.pointArray.getCoordinateReferenceSystem(), p0, p1, startParam);
            rSeg.setCurve(this.parentCurve);
            return rSeg;
        }

        public DirectPosition getStartDirectPositionCoordinate(int arg0, DirectPosition dp) {
            return this.pointArray.getDirectPosition(arg0, dp);
        }

        public DirectPosition getEndDirectPositionCoordinate(int arg0, DirectPosition dp) {
            return this.pointArray.getDirectPosition(arg0 + 1, dp);
        }

        public double[] getStartCoordinate(int arg0) {
            return this.pointArray.getCoordinate(arg0);
        }

        public double[] getEndCoordinate(int arg0) {
            return this.pointArray.getCoordinate(arg0 + 1);
        }

        @Override
        public int size() {
            return this.pointArray.length() - 1;
        }

        public boolean hasNext() {
            return this.index < this.pointArray.length() - 2;
        }

        public LineSegmentImpl next() {
            double[] p0 = this.getStartCoordinate(this.index);
            double[] p1 = this.getEndCoordinate(this.index);
            LineSegmentImpl ls = new LineSegmentImpl(this.pointArray.getCoordinateReferenceSystem(), p0, p1, this.length);
            this.length = DoubleOperation.add(this.length, AlgoPointND.getDistance(p0, p1));
            return ls;
        }
    }
}

