/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2001-2008, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2001-2006  Vivid Solutions
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.geometry.iso.topograph2D.util;

import org.geotools.geometry.iso.topograph2D.Coordinate;

/**
 * <code>Geometry</code> classes support the concept of applying a coordinate filter to every
 * coordinate in the <code>Geometry</code>. A coordinate filter can either record information about
 * each coordinate or change the coordinate in some way. Coordinate filters implement the interface
 * <code>CoordinateFilter</code>. (<code>CoordinateFilter</code> is an example of the Gang-of-Four
 * Visitor pattern). Coordinate filters can be used to implement such things as coordinate
 * transformations, centroid and envelope computation, and many other functions.
 *
 * @version 1.7.2
 */
public interface CoordinateFilter {

    /**
     * Performs an operation with or on <code>coord</code>.
     *
     * @param coord a <code>Coordinate</code> to which the filter is applied.
     */
    void filter(Coordinate coord);
}
