/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.geojson.GeoJSONDataStore;
import org.geotools.data.geojson.GeoJSONFeatureReader;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeoJSONFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature>,
AutoCloseable {
    Logger LOGGER = Logging.getLogger((String)"org.geotools.data.geojson");
    private ContentState state;
    private GeoJSONFeatureReader delegate;
    private File temp;
    private GeoJSONWriter writer;
    private SimpleFeature currentFeature;
    private boolean appending = false;
    private int nextRow = 0;

    public GeoJSONFeatureWriter(ContentEntry entry, Query query) throws IOException {
        this.state = entry.getState(Transaction.AUTO_COMMIT);
        String typeName = query.getTypeName();
        File file = URLs.urlToFile((URL)((GeoJSONDataStore)this.state.getEntry().getDataStore()).getUrl());
        File directory = file.getParentFile();
        this.temp = File.createTempFile(typeName + System.currentTimeMillis(), "geojson", directory);
        this.writer = new GeoJSONWriter(new FileOutputStream(this.temp));
        this.delegate = new GeoJSONFeatureReader(this.state, query);
    }

    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        if (this.writer == null) {
            return false;
        }
        if (this.appending) {
            return false;
        }
        return this.delegate.hasNext();
    }

    public SimpleFeature next() throws IOException {
        if (this.writer == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.currentFeature != null) {
            this.LOGGER.fine("writing " + this.currentFeature.getID());
            this.write();
        }
        try {
            if (!this.appending) {
                if (this.delegate.reader != null && this.delegate.hasNext()) {
                    this.currentFeature = this.delegate.next();
                    return this.currentFeature;
                }
                this.appending = true;
                this.LOGGER.fine("Now appending");
            }
            SimpleFeatureType featureType = this.state.getFeatureType();
            String fid = featureType.getTypeName() + "." + this.nextRow;
            Object[] values = DataUtilities.defaultValues((SimpleFeatureType)featureType);
            this.currentFeature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])values, (String)fid);
            return this.currentFeature;
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Unable to create feature: " + e.getLocalizedMessage(), e);
        }
    }

    public void remove() throws IOException {
        this.currentFeature = null;
    }

    public void write() throws IOException {
        if (this.currentFeature == null) {
            return;
        }
        this.writer.write(this.currentFeature);
        ++this.nextRow;
        this.currentFeature = null;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.writer == null) {
                throw new IOException("FeatureWriter already closed");
            }
            if (this.currentFeature != null) {
                this.write();
            }
            while (this.hasNext()) {
                this.next();
                this.write();
            }
            this.writer.close();
            if (this.delegate != null) {
                this.delegate.close();
                this.delegate = null;
            }
            File file = URLs.urlToFile((URL)((GeoJSONDataStore)this.state.getEntry().getDataStore()).getUrl());
            Files.copy(this.temp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            this.temp.delete();
        }
    }
}

