/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.geojson.GeoJSONDataStore;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.store.ContentState;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeoJSONFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private ContentState state;
    protected GeoJSONReader reader;
    private FeatureIterator<SimpleFeature> iterator;

    public GeoJSONFeatureReader(ContentState contentState, Query query) throws IOException {
        this.state = contentState;
        GeoJSONDataStore ds = (GeoJSONDataStore)this.state.getEntry().getDataStore();
        this.reader = ds.read();
    }

    public SimpleFeatureType getFeatureType() {
        GeoJSONDataStore ds = (GeoJSONDataStore)this.state.getEntry().getDataStore();
        try {
            SimpleFeatureType schema = ds.getSchema(this.state.getEntry().getName());
            if (schema == null) {
                schema = ds.getSchema("features");
            }
            return schema;
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            return null;
        }
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (this.iterator == null) {
            this.iterator = this.reader.getIterator();
        }
        return (SimpleFeature)this.iterator.next();
    }

    public boolean hasNext() throws IOException {
        if (this.iterator == null) {
            this.iterator = this.reader.getIterator();
        }
        return this.iterator.hasNext();
    }

    public void close() throws IOException {
        try {
            if (this.iterator != null) {
                this.iterator.close();
            }
        }
        finally {
            this.reader.close();
        }
    }
}

