/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.geotools.geojson.IContentHandler;
import org.geotools.geojson.TracingHandler;
import org.geotools.util.Converters;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.locationtech.jts.geom.Coordinate;

public class GeoJSONUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final TimeZone TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final FastDateFormat dateFormatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ", (TimeZone)TIME_ZONE);

    public static Reader toReader(Object input) throws IOException {
        if (input instanceof BufferedReader) {
            return (BufferedReader)input;
        }
        if (input instanceof Reader) {
            return new BufferedReader((Reader)input);
        }
        if (input instanceof InputStream) {
            return new BufferedReader(new InputStreamReader((InputStream)input));
        }
        if (input instanceof File) {
            return new BufferedReader(new FileReader((File)input));
        }
        if (input instanceof String) {
            return new StringReader((String)input);
        }
        throw new IllegalArgumentException("Unable to turn " + input + " into a reader");
    }

    public static Writer toWriter(final Object output) throws IOException {
        if (output instanceof OutputStreamWriter) {
            return new Writer(){
                Writer writer;
                {
                    this.writer = new BufferedWriter((Writer)output);
                }

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    this.writer.write(cbuf, off, len);
                }

                @Override
                public void flush() throws IOException {
                    this.writer.flush();
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
        if (output instanceof BufferedWriter) {
            return (BufferedWriter)output;
        }
        if (output instanceof Writer) {
            return new BufferedWriter((Writer)output);
        }
        if (output instanceof OutputStream) {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)output));
        }
        if (output instanceof File) {
            return new BufferedWriter(new FileWriter((File)output));
        }
        if (output instanceof String) {
            return new BufferedWriter(new FileWriter((String)output));
        }
        throw new IllegalArgumentException("Unable to turn " + output + " into a writer");
    }

    public static StringBuilder string(String string, StringBuilder sb) {
        sb.append("\"").append(JSONObject.escape((String)string)).append("\"");
        return sb;
    }

    public static StringBuilder entry(String key, Object value, StringBuilder sb) {
        GeoJSONUtil.string(key, sb).append(":");
        GeoJSONUtil.value(value, sb);
        return sb;
    }

    private static void value(Object value, StringBuilder sb) {
        if (value == null) {
            GeoJSONUtil.nul(sb);
        } else if (value.getClass().isArray()) {
            GeoJSONUtil.array(value, sb);
        } else if (value instanceof Number || value instanceof Boolean || value instanceof Date) {
            GeoJSONUtil.literal(value, sb);
        } else {
            String str = (String)Converters.convert((Object)value, String.class);
            if (str == null) {
                str = value.toString();
            }
            GeoJSONUtil.string(str, sb);
        }
    }

    private static void array(Object array, StringBuilder sb) {
        sb.append("[");
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array, i);
            GeoJSONUtil.value(value, sb);
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
    }

    static StringBuilder literal(Object value, StringBuilder sb) {
        if (value instanceof Date) {
            return GeoJSONUtil.string(dateFormatter.format((Date)value), sb);
        }
        return sb.append(value);
    }

    public static StringBuilder array(String key, Object value, StringBuilder sb) {
        return GeoJSONUtil.string(key, sb).append(":").append(value);
    }

    public static StringBuilder nul(StringBuilder sb) {
        sb.append("null");
        return sb;
    }

    public static <T> T trace(T handler, Class<T> clazz) {
        return (T)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new TracingHandler(handler));
    }

    public static boolean addOrdinate(List ordinates, Object value) {
        if (ordinates != null) {
            ordinates.add(value);
        }
        return true;
    }

    public static Coordinate createCoordinate(List ordinates) throws ParseException {
        Coordinate c = new Coordinate();
        if (ordinates.size() <= 1) {
            throw new ParseException(2, (Object)"Too few ordinates to create coordinate");
        }
        if (ordinates.size() > 1) {
            c.x = ((Number)ordinates.get(0)).doubleValue();
            c.y = ((Number)ordinates.get(1)).doubleValue();
        }
        if (ordinates.size() > 2) {
            c.setZ(((Number)ordinates.get(2)).doubleValue());
        }
        return c;
    }

    public static Coordinate[] createCoordinates(List coordinates) {
        return coordinates.toArray(new Coordinate[coordinates.size()]);
    }

    public static <T> T parse(IContentHandler<T> handler, Object input, boolean trace) throws IOException {
        try (Reader reader = GeoJSONUtil.toReader(input);){
            T t;
            if (trace) {
                handler = (IContentHandler)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{IContentHandler.class}, (InvocationHandler)new TracingHandler(handler));
            }
            JSONParser parser = new JSONParser();
            try {
                parser.parse(reader, handler);
                t = handler.getValue();
            }
            catch (ParseException e) {
                throw (IOException)new IOException().initCause(e);
            }
            return t;
        }
    }

    public static void encode(String json, Object output) throws IOException {
        try (Writer w = GeoJSONUtil.toWriter(output);){
            w.write(json);
            w.flush();
        }
    }

    public static void encode(Map<String, Object> obj, Object output) throws IOException {
        try (Writer w = GeoJSONUtil.toWriter(output);){
            JSONObject.writeJSONString(obj, (Writer)w);
            w.flush();
        }
    }
}

