/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson.store;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.geojson.store.GeoJSONDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.KVP;
import org.geotools.util.URLs;

public class GeoJSONDataStoreFactory
implements FileDataStoreFactorySpi {
    private static final String[] EXTENSIONS = new String[]{"geojson", "json", "gjson"};
    private Boolean isAvailable;
    public static final DataAccessFactory.Param FILE_PARAM = new DataAccessFactory.Param("file", File.class, "GeoJSON file", false, null, (Map)new KVP(new Object[]{"ext", "geojson"}));
    public static final DataAccessFactory.Param URL_PARAM = new DataAccessFactory.Param("url", URL.class, "GeoJSON URL", false, null, (Map)new KVP(new Object[]{"ext", "geojson"}));
    public static final DataAccessFactory.Param BOUNDING_BOX = new DataAccessFactory.Param("bbox", ReferencedEnvelope.class, "A bounding box for the features to be written", false);
    public static final DataAccessFactory.Param WRITE_BOUNDS = new DataAccessFactory.Param("bounds", Boolean.class, "Should a bounding box be written out if available", false);
    public static final DataAccessFactory.Param QUICK_SCHEMA = new DataAccessFactory.Param("quick", Boolean.class, "Should the schema be described by the first element of the collection (Default true)", false);

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    public String getDisplayName() {
        return "GeoJSON";
    }

    public String getDescription() {
        return "GeoJSON file or URL";
    }

    public DataStore createDataStore(Map<String, ?> params) throws IOException {
        Boolean quick;
        ReferencedEnvelope bbox;
        URL url = (URL)URL_PARAM.lookUp(params);
        File file = (File)FILE_PARAM.lookUp(params);
        if (url == null && file == null) {
            throw new IOException("No file or url parameter provided");
        }
        GeoJSONDataStore ret = file != null ? new GeoJSONDataStore(file) : new GeoJSONDataStore(url);
        Boolean bounds = (Boolean)WRITE_BOUNDS.lookUp(params);
        if (bounds != null) {
            ret.setWriteBounds(bounds);
        }
        if ((bbox = (ReferencedEnvelope)BOUNDING_BOX.lookUp(params)) != null) {
            ret.setBbox(bbox);
        }
        if ((quick = (Boolean)QUICK_SCHEMA.lookUp(params)) != null) {
            ret.setQuickSchema(quick);
        }
        return ret;
    }

    public DataStore createNewDataStore(Map<String, ?> params) throws IOException {
        Boolean quick;
        ReferencedEnvelope bbox;
        GeoJSONDataStore ret;
        URL url = (URL)URL_PARAM.lookUp(params);
        File file = (File)FILE_PARAM.lookUp(params);
        if (url == null && file == null) {
            throw new IOException("No file or url parameter provided");
        }
        if (url != null && "file".equalsIgnoreCase(url.getProtocol())) {
            file = URLs.urlToFile((URL)url);
        }
        if (file != null) {
            boolean ok;
            if (!file.exists() && !(ok = file.createNewFile())) {
                throw new IOException("Unable to create file " + String.valueOf(file.getAbsoluteFile()));
            }
            ret = new GeoJSONDataStore(file);
        } else {
            ret = new GeoJSONDataStore(url);
        }
        Boolean bounds = (Boolean)WRITE_BOUNDS.lookUp(params);
        if (bounds != null) {
            ret.setWriteBounds(bounds);
        }
        if ((bbox = (ReferencedEnvelope)BOUNDING_BOX.lookUp(params)) != null) {
            ret.setBbox(bbox);
        }
        if ((quick = (Boolean)QUICK_SCHEMA.lookUp(params)) != null) {
            ret.setQuickSchema(quick);
        }
        return ret;
    }

    public synchronized boolean isAvailable() {
        if (this.isAvailable == null) {
            try {
                Class<?> geoJSONReaderType = Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
                ObjectMapper mapper = new ObjectMapper();
                mapper.registerModule((Module)new JtsModule());
                this.isAvailable = true;
            }
            catch (ClassNotFoundException e) {
                this.isAvailable = false;
            }
        }
        return this.isAvailable;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{FILE_PARAM, URL_PARAM};
    }

    public String[] getFileExtensions() {
        return EXTENSIONS;
    }

    public boolean canProcess(Map<String, ?> params) {
        try {
            URL url = (URL)URL_PARAM.lookUp(params);
            File file = (File)FILE_PARAM.lookUp(params);
            if (file == null && url == null) {
                return false;
            }
            String name = file != null ? file.getPath().toLowerCase() : url.getPath().toLowerCase();
            for (String ext : EXTENSIONS) {
                if (!name.endsWith(ext)) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean canProcess(URL url) {
        String s = url.toString().toLowerCase();
        String extension = s.substring(s.lastIndexOf(".") + 1);
        Set set = Stream.of(EXTENSIONS).collect(Collectors.toSet());
        return set.contains(extension);
    }

    public FileDataStore createDataStore(URL url) {
        return new GeoJSONDataStore(url);
    }

    public FileDataStore createDataStore(File f) {
        return new GeoJSONDataStore(f);
    }

    public String getTypeName(URL url) {
        return null;
    }
}

