/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson.store;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.geojson.store.GeoJSONFeatureSource;
import org.geotools.data.geojson.store.GeoJSONFeatureStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.URLs;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoJSONDataStore
extends ContentDataStore
implements FileDataStore {
    private SimpleFeatureType schema;
    private URL url;
    private CoordinateReferenceSystem crs = DefaultGeographicCRS.WGS84;
    private NameImpl typeName;
    private boolean writeBounds;
    private ReferencedEnvelope bbox;
    private boolean quick = true;

    public GeoJSONDataStore(URL url) {
        this.setUrl(url);
    }

    public GeoJSONDataStore(File f) {
        this.setUrl(URLs.fileToUrl((File)f));
    }

    GeoJSONReader read() throws IOException {
        GeoJSONReader reader = new GeoJSONReader(this.getUrl(), GeoJSONReader.IdStrategy.PREFIX);
        return reader;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        if ("file".equalsIgnoreCase(this.getUrl().getProtocol())) {
            File f = URLs.urlToFile((URL)this.getUrl());
            if (!f.exists() && !f.createNewFile()) {
                return new GeoJSONFeatureSource(entry, Query.ALL);
            }
            if (f.canWrite()) {
                GeoJSONFeatureStore store = new GeoJSONFeatureStore(entry, Query.ALL);
                store.setWriteBounds(this.writeBounds);
                return store;
            }
        }
        return new GeoJSONFeatureSource(entry, Query.ALL);
    }

    protected List<Name> createTypeNames() throws IOException {
        if (this.schema != null) {
            return Collections.singletonList(new NameImpl(this.schema.getTypeName()));
        }
        String name = new File(this.getUrl().getFile()).getName();
        int index = name.lastIndexOf(46);
        name = index > 0 ? name.substring(0, index) : "Unamed URL";
        this.typeName = new NameImpl(name);
        return Collections.singletonList(this.typeName);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.schema = featureType;
    }

    public SimpleFeatureType getSchema() throws IOException {
        if (this.schema == null) {
            this.schema = this.getSchema((Name)this.typeName);
        }
        return this.schema;
    }

    protected SimpleFeatureType getCurrentSchema() throws IOException {
        return this.schema;
    }

    public void updateSchema(SimpleFeatureType featureType) throws IOException {
        this.schema = featureType;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public SimpleFeatureSource getFeatureSource() throws IOException {
        if (this.typeName == null) {
            this.createTypeNames();
        }
        return super.getFeatureSource((Name)this.typeName);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader() throws IOException {
        return new GeoJSONFeatureSource(this).getReader();
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Filter filter, Transaction transaction) throws IOException {
        return null;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Transaction transaction) throws IOException {
        return null;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(Transaction transaction) throws IOException {
        return null;
    }

    public Name getTypeName() {
        if (this.namespaceURI != null) {
            return new NameImpl(this.namespaceURI, this.typeName.getLocalPart());
        }
        return this.typeName;
    }

    public void setWriteBounds(boolean booleanValue) {
        this.writeBounds = booleanValue;
    }

    public boolean isWriteBounds() {
        return this.writeBounds;
    }

    public void setQuickSchema(boolean booleanValue) {
        this.quick = booleanValue;
    }

    public boolean isQuick() {
        return this.quick;
    }

    public ReferencedEnvelope getBbox() {
        return this.bbox;
    }

    public void setBbox(ReferencedEnvelope bbox) {
        this.bbox = bbox;
    }
}

