/*
 * Decompiled with CFR 0.152.
 */
package com.bedatadriven.jackson.datatype.jts.parsers;

import com.bedatadriven.jackson.datatype.jts.parsers.BaseParser;
import com.bedatadriven.jackson.datatype.jts.parsers.GeometryParser;
import com.bedatadriven.jackson.datatype.jts.parsers.PointParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;

public class MultiPointParser
extends BaseParser
implements GeometryParser<MultiPoint> {
    public MultiPointParser(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    public MultiPoint multiPointFromJson(JsonNode root) {
        Coordinate[] coords = PointParser.coordinatesFromJson(root.get("coordinates"));
        ArrayList<Point> points = new ArrayList<Point>();
        for (Coordinate coord : coords) {
            if (coord != null) {
                points.add(this.geometryFactory.createPoint(coord));
                continue;
            }
            points.add((Point)this.geometryFactory.createEmpty(0));
        }
        return this.geometryFactory.createMultiPoint(points.toArray(new Point[0]));
    }

    @Override
    public MultiPoint geometryFromJson(JsonNode node) throws JsonMappingException {
        return this.multiPointFromJson(node);
    }
}

