/*
 * Decompiled with CFR 0.152.
 */
package com.bedatadriven.jackson.datatype.jts.parsers;

import com.bedatadriven.jackson.datatype.jts.parsers.BaseParser;
import com.bedatadriven.jackson.datatype.jts.parsers.GeometryParser;
import com.bedatadriven.jackson.datatype.jts.parsers.PointParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class PolygonParser
extends BaseParser
implements GeometryParser<Polygon> {
    public PolygonParser(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    public Polygon polygonFromJson(JsonNode node) {
        JsonNode arrayOfRings = node.get("coordinates");
        return this.polygonFromJsonArrayOfRings(arrayOfRings);
    }

    public Polygon polygonFromJsonArrayOfRings(JsonNode arrayOfRings) {
        if (arrayOfRings == null || arrayOfRings.isEmpty()) {
            return (Polygon)this.geometryFactory.createEmpty(2);
        }
        LinearRing shell = this.linearRingsFromJson(arrayOfRings.get(0));
        int size = arrayOfRings.size();
        LinearRing[] holes = new LinearRing[size - 1];
        for (int i = 1; i < size; ++i) {
            holes[i - 1] = this.linearRingsFromJson(arrayOfRings.get(i));
        }
        return this.geometryFactory.createPolygon(shell, holes);
    }

    private LinearRing linearRingsFromJson(JsonNode coordinates) {
        if (coordinates == null) {
            return this.geometryFactory.createLinearRing((Coordinate[])null);
        }
        return this.geometryFactory.createLinearRing(PointParser.coordinatesFromJson(coordinates));
    }

    @Override
    public Polygon geometryFromJson(JsonNode node) throws JsonMappingException {
        return this.polygonFromJson(node);
    }
}

