/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.geobuf.Geobuf;
import org.geotools.data.geobuf.GeobufDataStore;
import org.geotools.data.geobuf.GeobufDirectoryDataStore;
import org.geotools.data.geobuf.GeobufFeature;
import org.geotools.data.geobuf.GeobufFeatureReader;
import org.geotools.data.geobuf.GeobufFeatureType;
import org.geotools.data.geobuf.GeobufGeometry;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeobufFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private ContentState state;
    private File temp;
    private Geobuf.Data.Builder dataBuilder;
    private Geobuf.Data.FeatureCollection.Builder featureCollectionBuilder;
    private GeobufFeatureReader delegate;
    private boolean appending = false;
    private SimpleFeature currentFeature;
    private int nextRow = 0;
    private GeobufFeature geobufFeature;
    private File file;

    public GeobufFeatureWriter(ContentState state, Query query, int precision, int dimension) throws IOException {
        this.state = state;
        String typeName = query.getTypeName();
        ContentDataStore dataStore = state.getEntry().getDataStore();
        this.file = dataStore instanceof GeobufDirectoryDataStore ? ((GeobufDirectoryDataStore)dataStore).getDataStore(typeName).getFile() : ((GeobufDataStore)dataStore).getFile();
        File directory = this.file.getParentFile();
        this.temp = File.createTempFile(typeName + System.currentTimeMillis(), "geobuf", directory);
        this.dataBuilder = Geobuf.Data.newBuilder();
        GeobufFeatureType geobufFeatureType = new GeobufFeatureType();
        geobufFeatureType.encode(state.getFeatureType(), this.dataBuilder);
        ((Geobuf.Data)this.dataBuilder.build()).writeTo(new FileOutputStream(this.temp));
        this.featureCollectionBuilder = Geobuf.Data.FeatureCollection.newBuilder();
        this.geobufFeature = new GeobufFeature(new GeobufGeometry(precision, dimension));
        this.delegate = new GeobufFeatureReader(state, query, precision, dimension);
    }

    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public SimpleFeature next() throws IOException {
        if (this.dataBuilder == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        try {
            if (!this.appending) {
                if (this.delegate.hasNext()) {
                    this.currentFeature = this.delegate.next();
                    return this.currentFeature;
                }
                this.appending = true;
            }
            SimpleFeatureType featureType = this.state.getFeatureType();
            String fid = featureType.getTypeName() + "." + this.nextRow;
            Object[] values = DataUtilities.defaultValues((SimpleFeatureType)featureType);
            this.currentFeature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])values, (String)fid);
            return this.currentFeature;
        }
        catch (IllegalArgumentException invalid) {
            throw new IOException("Unable to create feature:" + invalid.getMessage(), invalid);
        }
    }

    public void remove() throws IOException {
        this.currentFeature = null;
    }

    public void write() throws IOException {
        if (this.currentFeature == null) {
            return;
        }
        this.featureCollectionBuilder.addFeatures(this.geobufFeature.encode(this.currentFeature));
        ++this.nextRow;
        this.currentFeature = null;
    }

    public boolean hasNext() throws IOException {
        if (this.dataBuilder == null) {
            return false;
        }
        if (this.appending) {
            return false;
        }
        return this.delegate.hasNext();
    }

    public void close() throws IOException {
        if (this.dataBuilder == null) {
            throw new IOException("Writer alread closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        while (this.hasNext()) {
            this.next();
            this.write();
        }
        this.dataBuilder.setFeatureCollection((Geobuf.Data.FeatureCollection)this.featureCollectionBuilder.build());
        Geobuf.Data data = (Geobuf.Data)this.dataBuilder.build();
        data.writeTo(new FileOutputStream(this.temp));
        this.dataBuilder = null;
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
        Files.copy(this.temp.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.temp.delete();
    }
}

