/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.geotools.data.geobuf.Geobuf;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class GeobufFeatureType {
    private int precision;
    private int dimension;

    public GeobufFeatureType() {
        this(6, 2);
    }

    public GeobufFeatureType(int precision, int dimension) {
        this.precision = precision;
        this.dimension = dimension;
    }

    public void encode(SimpleFeatureType featureType, OutputStream out) throws IOException {
        Geobuf.Data.Builder dataBuilder = Geobuf.Data.newBuilder();
        this.encode(featureType, dataBuilder);
        Geobuf.Data data = (Geobuf.Data)dataBuilder.build();
        data.writeTo(out);
    }

    public SimpleFeatureType decode(String name, InputStream inputStream) throws IOException {
        Geobuf.Data data = Geobuf.Data.parseFrom(inputStream);
        return this.getFeatureType(name, data);
    }

    protected void encode(SimpleFeatureType featureType, Geobuf.Data.Builder dataBuilder) {
        for (AttributeDescriptor descriptor : featureType.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) continue;
            dataBuilder.addKeys(descriptor.getLocalName());
        }
        dataBuilder.setDimensions(this.dimension);
        dataBuilder.setPrecision(this.precision);
        dataBuilder.setFeatureCollection((Geobuf.Data.FeatureCollection)Geobuf.Data.FeatureCollection.newBuilder().build());
    }

    protected SimpleFeatureType getFeatureType(String name, Geobuf.Data data) throws IOException {
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.setName(name);
        if (data.getDataTypeCase() == Geobuf.Data.DataTypeCase.GEOMETRY) {
            featureTypeBuilder.setDefaultGeometry("geom");
            featureTypeBuilder.add("geom", this.getGeometryType(data.getGeometry()));
        } else if (data.getDataTypeCase() == Geobuf.Data.DataTypeCase.FEATURE) {
            featureTypeBuilder.setDefaultGeometry("geom");
            featureTypeBuilder.add("geom", this.getGeometryType(data.getFeature().getGeometry()));
            int keyCount = data.getKeysCount();
            for (int i = 0; i < keyCount; ++i) {
                String key = data.getKeys(i);
                Class<?> type = this.getType(data.getFeature().getValues(i).getValueTypeCase());
                featureTypeBuilder.add(key, type);
            }
        } else if (data.getDataTypeCase() == Geobuf.Data.DataTypeCase.FEATURE_COLLECTION) {
            featureTypeBuilder.setDefaultGeometry("geom");
            if (data.getFeatureCollection().getFeaturesCount() == 0) {
                featureTypeBuilder.add("geom", Geometry.class);
            } else {
                featureTypeBuilder.add("geom", this.getGeometryType(data.getFeatureCollection().getFeatures(0).getGeometry()));
            }
            int keyCount = data.getKeysCount();
            for (int i = 0; i < keyCount; ++i) {
                String key = data.getKeys(i);
                Class type = String.class;
                if (data.getFeatureCollection().getFeaturesCount() > 0 && i < data.getFeatureCollection().getFeatures(0).getValuesCount()) {
                    type = this.getType(data.getFeatureCollection().getFeatures(0).getValues(i).getValueTypeCase());
                }
                featureTypeBuilder.add(key, type);
            }
        } else {
            throw new IOException("Unknown Data Type!");
        }
        return featureTypeBuilder.buildFeatureType();
    }

    protected Class<?> getType(Geobuf.Data.Value.ValueTypeCase vtc) {
        if (vtc == Geobuf.Data.Value.ValueTypeCase.STRING_VALUE) {
            return String.class;
        }
        if (vtc == Geobuf.Data.Value.ValueTypeCase.POS_INT_VALUE || vtc == Geobuf.Data.Value.ValueTypeCase.NEG_INT_VALUE) {
            return Integer.class;
        }
        if (vtc == Geobuf.Data.Value.ValueTypeCase.BOOL_VALUE) {
            return Boolean.class;
        }
        if (vtc == Geobuf.Data.Value.ValueTypeCase.DOUBLE_VALUE) {
            return Boolean.class;
        }
        if (vtc == Geobuf.Data.Value.ValueTypeCase.JSON_VALUE) {
            return String.class;
        }
        return Object.class;
    }

    protected Class<? extends Geometry> getGeometryType(Geobuf.Data.Geometry g) {
        if (g.getType() == Geobuf.Data.Geometry.Type.POINT) {
            return Point.class;
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.LINESTRING) {
            return LineString.class;
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.POLYGON) {
            return Polygon.class;
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.MULTIPOINT) {
            return MultiPoint.class;
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.MULTILINESTRING) {
            return MultiLineString.class;
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.MULTIPOLYGON) {
            return MultiPolygon.class;
        }
        if (g.getType() == Geobuf.Data.Geometry.Type.GEOMETRYCOLLECTION) {
            return GeometryCollection.class;
        }
        return Geometry.class;
    }
}

