/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.io.FileInputStream;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.geobuf.GeobufDataStore;
import org.geotools.data.geobuf.GeobufDirectoryDataStore;
import org.geotools.data.geobuf.GeobufFeatureCollection;
import org.geotools.data.geobuf.GeobufFeatureReader;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeobufFeatureSource
extends ContentFeatureSource {
    private int precision = 6;
    private int dimension = 2;

    public GeobufFeatureSource(ContentEntry entry, Query query, int precision, int dimension) {
        super(entry, query);
        this.precision = precision;
        this.dimension = dimension;
    }

    public GeobufDataStore getDataStore() {
        ContentDataStore dataStore = super.getDataStore();
        if (dataStore instanceof GeobufDirectoryDataStore) {
            return ((GeobufDirectoryDataStore)dataStore).getDataStore(this.entry.getTypeName());
        }
        return (GeobufDataStore)dataStore;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new GeobufFeatureReader(this.getState(), query, this.precision, this.dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        try (FileInputStream in = new FileInputStream(this.getDataStore().getFile());){
            GeobufFeatureCollection geobufFeatureCollection = new GeobufFeatureCollection();
            ReferencedEnvelope referencedEnvelope = geobufFeatureCollection.getBounds(in);
            return referencedEnvelope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCountInternal(Query query) throws IOException {
        try (FileInputStream in = new FileInputStream(this.getDataStore().getFile());){
            GeobufFeatureCollection geobufFeatureCollection = new GeobufFeatureCollection();
            int n = geobufFeatureCollection.countFeatures(in);
            return n;
        }
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.getDataStore().getFeatureType();
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }
}

