/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.geotools.data.geobuf.Geobuf;
import org.geotools.data.geobuf.GeobufFeature;
import org.geotools.data.geobuf.GeobufFeatureType;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class GeobufFeatureCollection {
    private GeobufFeature geobufFeature;

    public GeobufFeatureCollection() {
        this(new GeobufFeature());
    }

    public GeobufFeatureCollection(GeobufFeature geobufFeature) {
        this.geobufFeature = geobufFeature;
    }

    public SimpleFeatureCollection decode(InputStream in) throws IOException {
        Geobuf.Data data = Geobuf.Data.parseFrom(in);
        return this.decode(data);
    }

    public void encode(SimpleFeatureCollection featureCollection, OutputStream out) throws IOException {
        this.encode(featureCollection).writeTo(out);
    }

    protected SimpleFeatureCollection decode(Geobuf.Data data) throws IOException {
        GeobufFeatureType geobufFeatureType = new GeobufFeatureType(this.geobufFeature.getGeobufGeometry().getPrecision(), this.geobufFeature.getGeobufGeometry().getDimension());
        SimpleFeatureType featureType = geobufFeatureType.getFeatureType("features", data);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        MemoryDataStore memoryDataStore = new MemoryDataStore(featureType);
        for (int i = 0; i < data.getFeatureCollection().getFeaturesCount(); ++i) {
            memoryDataStore.addFeature(this.geobufFeature.decode(data, i, featureBuilder));
        }
        return memoryDataStore.getFeatureSource("features").getFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Geobuf.Data.FeatureCollection encodeAsFeatureCollection(SimpleFeatureCollection featureCollection) {
        Geobuf.Data.FeatureCollection.Builder featureCollectionBuilder = Geobuf.Data.FeatureCollection.newBuilder();
        try (SimpleFeatureIterator it = featureCollection.features();){
            while (it.hasNext()) {
                featureCollectionBuilder.addFeatures(this.geobufFeature.encode((SimpleFeature)it.next()));
            }
        }
        return (Geobuf.Data.FeatureCollection)featureCollectionBuilder.build();
    }

    protected Geobuf.Data encode(SimpleFeatureCollection featureCollection) {
        Geobuf.Data.Builder dataBuilder = Geobuf.Data.newBuilder();
        for (AttributeDescriptor descriptor : ((SimpleFeatureType)featureCollection.getSchema()).getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) continue;
            dataBuilder.addKeys(descriptor.getLocalName());
        }
        dataBuilder.setDimensions(this.geobufFeature.getGeobufGeometry().getDimension());
        dataBuilder.setPrecision(this.geobufFeature.getGeobufGeometry().getPrecision());
        dataBuilder.setFeatureCollection(this.encodeAsFeatureCollection(featureCollection));
        Geobuf.Data data = (Geobuf.Data)dataBuilder.build();
        return data;
    }

    protected int countFeatures(InputStream in) throws IOException {
        Geobuf.Data data = Geobuf.Data.parseFrom(in);
        if (data.getDataTypeCase() == Geobuf.Data.DataTypeCase.GEOMETRY) {
            return 1;
        }
        if (data.getDataTypeCase() == Geobuf.Data.DataTypeCase.FEATURE) {
            return 1;
        }
        if (data.getDataTypeCase() == Geobuf.Data.DataTypeCase.FEATURE_COLLECTION) {
            return data.getFeatureCollection().getFeaturesCount();
        }
        return -1;
    }

    protected ReferencedEnvelope getBounds(InputStream in) throws IOException {
        Geobuf.Data data = Geobuf.Data.parseFrom(in);
        if (data.getDataTypeCase() == Geobuf.Data.DataTypeCase.GEOMETRY) {
            Geometry g = this.geobufFeature.getGeobufGeometry().decode(data.getGeometry());
            Envelope env = g.getEnvelopeInternal();
            return new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), null);
        }
        if (data.getDataTypeCase() == Geobuf.Data.DataTypeCase.FEATURE) {
            Geometry g = (Geometry)this.geobufFeature.decode(data).getDefaultGeometry();
            Envelope env = g.getEnvelopeInternal();
            return new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), null);
        }
        if (data.getDataTypeCase() == Geobuf.Data.DataTypeCase.FEATURE_COLLECTION) {
            SimpleFeatureCollection fc = this.decode(data);
            return fc.getBounds();
        }
        return null;
    }
}

